/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.math;

import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class BinaryRealTypeMathTest
extends AbstractOpTest {
    private static final DoubleType A = new DoubleType(12.0);
    private static final IntType B = new IntType(7);
    private static String[] methods = new String[]{"function", "computer"};

    @Test
    public void testAdd() {
        DoubleType e = A.copy();
        e.set(e.get() + (double)B.get());
        this.test("math.add", e.get());
    }

    @Test
    public void testSub() {
        DoubleType e = A.copy();
        e.set(e.get() - (double)B.get());
        this.test("math.sub", e.get());
    }

    @Test
    public void testDiv() {
        DoubleType e = A.copy();
        e.set(e.get() / (double)B.get());
        this.test("math.div", e.get());
    }

    @Test
    public void testMul() {
        DoubleType e = A.copy();
        e.set(e.get() * (double)B.get());
        this.test("math.mul", e.get());
    }

    @Test
    public void testPow() {
        DoubleType e = A.copy();
        e.set(Math.pow(e.get(), B.get()));
        this.test("math.pow", e.get());
    }

    @Test
    public void testMod() {
        this.test("math.mod", A.get() % (double)B.get());
    }

    @Test
    public void testOr() {
        this.test("math.or", (int)((long)A.get() | (long)B.get()));
    }

    @Test
    public void testXor() {
        this.test("math.xor", (int)((long)A.get() ^ (long)B.get()));
    }

    @Test
    public void testAnd() {
        this.test("math.and", (int)((long)A.get() & (long)B.get()));
    }

    private void test(String opNames, double expectedValue) {
        for (String opName : opNames.split(", ")) {
            for (String m : methods) {
                DoubleType c = new DoubleType();
                ops.op(opName).input((Object)A, (Object)B).output((Object)c).compute();
                Assertions.assertEquals((double)expectedValue, (double)c.get());
            }
        }
    }
}

