/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.morphology.thin;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.test.ImgLib2Assert;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.morphology.thin.AbstractThin;
import org.scijava.types.Nil;

public class ThinningTest
extends AbstractOpTest {
    private Img<BitType> in;
    private Img<BitType> target;

    @BeforeEach
    public void initialize() {
        Img<FloatType> testImg = ThinningTest.openRelativeFloatImg(AbstractOpTest.class, "features/3d_geometric_features_testlabel.tif");
        this.in = (Img)ops.op("create.img").input(testImg, (Object)new BitType()).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        this.target = (Img)ops.op("create.img").input(this.in, (Object)new BitType()).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        ops.op("convert.bit").input(testImg).output(this.in).compute();
    }

    @Test
    public void testThinGuoHall() {
        Img out = (Img)ops.op("morphology.thinGuoHall").input(this.in).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        ops.op("convert.bit").input(ThinningTest.openRelativeFloatImg(AbstractThin.class, "result_guoHall.tif")).output(this.target).compute();
        ImgLib2Assert.assertImageEquals(this.target, (RandomAccessibleInterval)out);
    }

    @Test
    public void testThinHilditch() {
        Img out = (Img)ops.op("morphology.thinHilditch").input(this.in).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        ops.op("convert.bit").input(ThinningTest.openRelativeFloatImg(AbstractThin.class, "result_hilditch.tif")).output(this.target).compute();
        ImgLib2Assert.assertImageEquals(this.target, (RandomAccessibleInterval)out);
    }

    @Test
    public void testMorphological() {
        Img out = (Img)ops.op("morphology.thinMorphological").input(this.in).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        ops.op("convert.bit").input(ThinningTest.openRelativeFloatImg(AbstractThin.class, "result_morphological.tif")).output(this.target).compute();
        ImgLib2Assert.assertImageEquals(this.target, (RandomAccessibleInterval)out);
    }

    @Test
    public void testZhangSuen() {
        Img out = (Img)ops.op("morphology.thinZhangSuen").input(this.in).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        ops.op("convert.bit").input(ThinningTest.openRelativeFloatImg(AbstractThin.class, "result_zhangSuen.tif")).output(this.target).compute();
        ImgLib2Assert.assertImageEquals(this.target, (RandomAccessibleInterval)out);
    }
}

