/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats.regression.leastSquares;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class QuadricTest
extends AbstractOpTest {
    private static final double alpha = Math.cos(0.7853981633974483);
    private static final List<Vector3d> unitSpherePoints = Stream.of(new Vector3d(1.0, 0.0, 0.0), new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, -1.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(alpha, alpha, 0.0), new Vector3d(-alpha, alpha, 0.0), new Vector3d(alpha, -alpha, 0.0), new Vector3d(-alpha, -alpha, 0.0), new Vector3d(0.0, alpha, alpha), new Vector3d(0.0, -alpha, alpha), new Vector3d(0.0, alpha, -alpha), new Vector3d(0.0, -alpha, -alpha), new Vector3d(alpha, 0.0, alpha), new Vector3d(alpha, 0.0, -alpha), new Vector3d(-alpha, 0.0, alpha), new Vector3d(-alpha, 0.0, -alpha)).collect(Collectors.toList());

    @Test
    public void testEquation() {
        Matrix4dc solution = (Matrix4dc)ops.op("stats.leastSquares").input(unitSpherePoints).outType(Matrix4dc.class).apply();
        double a = solution.m00();
        double b = solution.m11();
        double c = solution.m22();
        double d = solution.m01();
        double e = solution.m02();
        double f = solution.m12();
        double g = solution.m03();
        double h = solution.m13();
        double i = solution.m23();
        for (Vector3d p : unitSpherePoints) {
            double polynomial = a * p.x * p.x + b * p.y * p.y + c * p.z * p.z + 2.0 * d * p.x * p.y + 2.0 * e * p.x * p.z + 2.0 * f * p.y * p.z + 2.0 * g * p.x + 2.0 * h * p.y + 2.0 * i * p.z;
            Assertions.assertEquals((double)1.0, (double)polynomial, (double)1.0E-12, (String)"The matrix does not solve the polynomial equation");
        }
    }

    @Test
    public void testMatchingFailsIfTooFewPoints() {
        int nPoints = Math.max(0, 8);
        List points = Stream.generate(Vector3d::new).limit(nPoints).collect(Collectors.toList());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ops.op("stats.leastSquares").input((Object)points).outType(Matrix4d.class).apply());
    }

    @Test
    public void testMatrixElements() {
        Matrix4dc solution = (Matrix4dc)ops.op("stats.leastSquares").input(unitSpherePoints).outType(Matrix4d.class).apply();
        Assertions.assertEquals((double)1.0, (double)solution.m00(), (double)1.0E-12, (String)"The matrix element is incorrect");
        Assertions.assertEquals((double)1.0, (double)solution.m11(), (double)1.0E-12, (String)"The matrix element is incorrect");
        Assertions.assertEquals((double)1.0, (double)solution.m22(), (double)1.0E-12, (String)"The matrix element is incorrect");
        Assertions.assertEquals((double)0.0, (double)solution.m01(), (double)1.0E-12, (String)"The matrix element is incorrect");
        Assertions.assertEquals((double)0.0, (double)solution.m02(), (double)1.0E-12, (String)"The matrix element is incorrect");
        Assertions.assertEquals((double)0.0, (double)solution.m03(), (double)1.0E-12, (String)"The matrix element is incorrect");
        Assertions.assertEquals((double)0.0, (double)solution.m12(), (double)1.0E-12, (String)"The matrix element is incorrect");
        Assertions.assertEquals((double)0.0, (double)solution.m13(), (double)1.0E-12, (String)"The matrix element is incorrect");
        Assertions.assertEquals((double)0.0, (double)solution.m23(), (double)1.0E-12, (String)"The matrix element is incorrect");
        Assertions.assertEquals((double)-1.0, (double)solution.m33(), (double)1.0E-12, (String)"The matrix element is incorrect");
        Matrix4d transposed = new Matrix4d();
        solution.transpose(transposed);
        Assertions.assertEquals((Object)solution, (Object)transposed, (String)"Matrix is not symmetric");
    }
}

