/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.threshold.AbstractThresholdTest;
import org.scijava.types.Nil;

public class ComputeThresholdTest
extends AbstractThresholdTest {
    @Test
    public void testHuang() {
        this.testComputeThresholdOp(36874, "threshold.huang");
    }

    @Test
    public void testIJ1() {
        this.testComputeThresholdOp(31836, "threshold.ij1");
    }

    @Test
    public void testIntermodes() {
        this.testComputeThresholdOp(34859, "threshold.intermodes");
    }

    @Test
    public void testIsoData() {
        this.testComputeThresholdOp(33095, "threshold.isoData");
    }

    @Test
    public void testLi() {
        this.testComputeThresholdOp(26798, "threshold.li");
    }

    @Test
    public void testMaxEntropy() {
        this.testComputeThresholdOp(28309, "threshold.maxEntropy");
    }

    @Test
    public void testMaxLikelihood() {
        this.testComputeThresholdOp(46698, "threshold.maxLikelihood");
    }

    @Test
    public void testMean() {
        this.testComputeThresholdOp(32591, "threshold.mean");
    }

    @Test
    public void testMinError() {
        this.testComputeThresholdOp(32843, "threshold.minError");
    }

    @Test
    public void testMinimum() {
        this.testComputeThresholdOp(44935, "threshold.minimum");
    }

    @Test
    public void testMoments() {
        this.testComputeThresholdOp(34355, "threshold.moments");
    }

    @Test
    public void testOtsu() {
        this.testComputeThresholdOp(34103, "threshold.otsu");
    }

    @Test
    public void testPercentile() {
        this.testComputeThresholdOp(32088, "threshold.percentile");
    }

    @Test
    public void testRenyiEntropy() {
        this.testComputeThresholdOp(26546, "threshold.renyiEntropy");
    }

    @Test
    public void testShanbhag() {
        this.testComputeThresholdOp(27553, "threshold.shanbhag");
    }

    @Test
    public void testTriangle() {
        this.testComputeThresholdOp(34607, "threshold.triangle");
    }

    @Test
    public void testYen() {
        this.testComputeThresholdOp(24531, "threshold.yen");
    }

    private void testComputeThresholdOp(int expectedOutput, String name) {
        Computers.Arity1<Histogram1d<UnsignedShortType>, UnsignedShortType> opToTest = this.getComputeThresholdOp(name);
        UnsignedShortType actualOutput = new UnsignedShortType();
        opToTest.compute(this.histogram(), (Object)actualOutput);
        this.assertThreshold(expectedOutput, actualOutput);
    }

    private Computers.Arity1<Histogram1d<UnsignedShortType>, UnsignedShortType> getComputeThresholdOp(String name) {
        return OpBuilder.matchComputer((OpEnvironment)ops, (String)name, (Nil)new Nil<Histogram1d<UnsignedShortType>>(){}, (Nil)new Nil<UnsignedShortType>(){});
    }
}

