/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.interpolateView;

import java.util.function.BiFunction;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.FloorInterpolatorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class InterpolateViewTest
extends AbstractOpTest {
    private static final long SEED = 305419896L;

    @Test
    public void testDefaultInterpolate() {
        BiFunction interpolateFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.interpolateView", (Nil)new Nil<RandomAccessible<DoubleType>>(){}, (Nil)new Nil<FloorInterpolatorFactory<DoubleType>>(){}, (Nil)new Nil<RealRandomAccessible<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        for (DoubleType d : img) {
            d.set(r.nextDouble());
        }
        RealRandomAccess il2 = Views.interpolate((EuclideanSpace)img, (InterpolatorFactory)new FloorInterpolatorFactory()).realRandomAccess();
        RealRandomAccess opr = ((RealRandomAccessible)interpolateFunc.apply(img, new FloorInterpolatorFactory())).realRandomAccess();
        il2.setPosition(new double[]{1.75, 5.34});
        opr.setPosition(new double[]{1.75, 5.34});
        Assertions.assertEquals((double)((DoubleType)il2.get()).get(), (double)((DoubleType)opr.get()).get(), (double)1.0E-10);
        il2.setPosition(new double[]{3.0, 7.0});
        opr.setPosition(new double[]{3.0, 7.0});
        Assertions.assertEquals((double)((DoubleType)il2.get()).get(), (double)((DoubleType)opr.get()).get(), (double)1.0E-10);
        il2.setPosition(new double[]{8.37, 3.97});
        opr.setPosition(new double[]{8.37, 3.97});
        Assertions.assertEquals((double)((DoubleType)il2.get()).get(), (double)((DoubleType)opr.get()).get(), (double)1.0E-10);
    }
}

