/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.project.project;

import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class ProjectTest
extends AbstractOpTest {
    private final int PROJECTION_DIM = 2;
    private Img<UnsignedByteType> in;
    private Img<UnsignedByteType> out1;
    private Img<UnsignedByteType> out2;
    private Computers.Arity1<Iterable<UnsignedByteType>, UnsignedByteType> op;

    @BeforeEach
    public void initImg() {
        this.in = TestImgGeneration.unsignedByteArray(false, 10L, 10L, 10L);
        RandomAccess randomAccess = this.in.randomAccess();
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                for (int z = 0; z < 10; ++z) {
                    randomAccess.setPosition(new long[]{x, y, z});
                    ((UnsignedByteType)randomAccess.get()).setReal((float)(x + y));
                }
            }
        }
        this.out1 = TestImgGeneration.unsignedByteArray(false, 10L, 10L);
        this.out2 = TestImgGeneration.unsignedByteArray(false, 10L, 10L);
        this.op = OpBuilder.matchComputer((OpEnvironment)ops, (String)"stats.sum", (Nil)new Nil<Iterable<UnsignedByteType>>(){}, (Nil)new Nil<UnsignedByteType>(){});
    }

    @Test
    public void testProjector() {
        ops.op("transform.project").input(this.in, this.op, (Object)2).output(this.out1).compute();
        ops.op("transform.project").input(this.in, this.op, (Object)2).output(this.out2).compute();
        this.testEquality(this.out1, this.out2);
    }

    private void testEquality(Img<UnsignedByteType> img1, Img<UnsignedByteType> img2) {
        RandomAccess img1RandomAccess = img1.randomAccess();
        RandomAccess img2RandomAccess = img2.randomAccess();
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                img1RandomAccess.setPosition(new long[]{x, y});
                img2RandomAccess.setPosition(new long[]{x, y});
                Assertions.assertEquals((long)((UnsignedByteType)img1RandomAccess.get()).get(), (long)(this.in.dimension(2) * (long)(x + y)));
                Assertions.assertEquals((long)((UnsignedByteType)img2RandomAccess.get()).get(), (long)(this.in.dimension(2) * (long)(x + y)));
            }
        }
    }
}

