/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.util;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.util.BigComplex;

public class BigComplexTest {
    private static final double PRECISION = 1.0E-13;

    @Test
    public void testAdd() {
        BigComplex a = new BigComplex();
        BigComplex b = new BigComplex();
        a.setComplexNumber(5.0f, 10.0f);
        b.setComplexNumber(-3.0f, 2.0f);
        a.add(b);
        Assertions.assertEquals((double)2.0, (double)a.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)12.0, (double)a.getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testSub() {
        BigComplex a = new BigComplex();
        BigComplex b = new BigComplex();
        a.setComplexNumber(5.0f, 10.0f);
        b.setComplexNumber(-3.0f, 2.0f);
        a.sub(b);
        Assertions.assertEquals((double)8.0, (double)a.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)8.0, (double)a.getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testMul() {
        BigComplex a = new BigComplex();
        BigComplex b = new BigComplex();
        a.setComplexNumber(5.0f, 0.0f);
        b.setComplexNumber(-3.0f, 0.0f);
        a.mul(b);
        Assertions.assertEquals((double)-15.0, (double)a.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)a.getImaginaryDouble(), (double)0.0);
        a.setComplexNumber(4.0f, 3.0f);
        b.setComplexNumber(9.0f, 1.0f);
        a.mul(b);
        Assertions.assertEquals((double)33.0, (double)a.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)31.0, (double)a.getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testDiv() {
        BigComplex a = new BigComplex();
        BigComplex b = new BigComplex();
        a.setComplexNumber(5.0f, 0.0f);
        b.setComplexNumber(-2.0f, 0.0f);
        a.div(b);
        Assertions.assertEquals((double)-2.5, (double)a.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)a.getImaginaryDouble(), (double)0.0);
        a.setComplexNumber(4.0f, 3.0f);
        b.setComplexNumber(9.0f, 1.0f);
        a.div(b);
        Assertions.assertEquals((double)0.47560975609756095, (double)a.getRealDouble(), (double)0.0);
        Assertions.assertEquals((double)0.2804878048780488, (double)a.getImaginaryDouble(), (double)0.0);
    }

    @Test
    public void testPhase() {
        BigComplex val = new BigComplex(1L, 0L);
        Assertions.assertEquals((double)0.0, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(0L, 1L);
        Assertions.assertEquals((double)1.5707963267948966, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(-1L, 0L);
        Assertions.assertEquals((double)Math.PI, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(0L, -1L);
        Assertions.assertEquals((double)4.71238898038469, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(1L, 1L);
        Assertions.assertEquals((double)0.7853981633974483, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(-1L, 1L);
        Assertions.assertEquals((double)2.356194490192345, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(-1L, -1L);
        Assertions.assertEquals((double)3.9269908169872414, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(1L, -1L);
        Assertions.assertEquals((double)5.497787143782138, (double)val.getPhaseDouble(), (double)1.0E-13);
        double half = 0.5;
        double root3over2 = Math.sqrt(3.0) / 2.0;
        val = new BigComplex(half, root3over2);
        Assertions.assertEquals((double)1.0471975511965976, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(-half, root3over2);
        Assertions.assertEquals((double)2.0943951023931953, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(half, -root3over2);
        Assertions.assertEquals((double)5.235987755982989, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(-half, -root3over2);
        Assertions.assertEquals((double)4.1887902047863905, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(root3over2, half);
        Assertions.assertEquals((double)0.5235987755982988, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(-root3over2, half);
        Assertions.assertEquals((double)2.6179938779914944, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(root3over2, -half);
        Assertions.assertEquals((double)5.759586531581287, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(-root3over2, -half);
        Assertions.assertEquals((double)3.665191429188092, (double)val.getPhaseDouble(), (double)1.0E-13);
        val = new BigComplex(7L, -3L);
        Assertions.assertEquals((double)(Math.PI * 2 - Math.atan(0.42857142857142855)), (double)val.getPhaseDouble(), (double)1.0E-13);
    }

    @Test
    public void testPower() {
        BigComplex val = new BigComplex(1L, 0L);
        Assertions.assertEquals((double)1.0, (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(2L, 0L);
        Assertions.assertEquals((double)2.0, (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(3L, 0L);
        Assertions.assertEquals((double)3.0, (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(4L, 0L);
        Assertions.assertEquals((double)4.0, (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(0L, 1L);
        Assertions.assertEquals((double)1.0, (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(0L, 2L);
        Assertions.assertEquals((double)2.0, (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(0L, 3L);
        Assertions.assertEquals((double)3.0, (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(0L, 4L);
        Assertions.assertEquals((double)4.0, (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(1L, 1L);
        Assertions.assertEquals((double)Math.sqrt(2.0), (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(2L, 2L);
        Assertions.assertEquals((double)(2.0 * Math.sqrt(2.0)), (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(3L, 3L);
        Assertions.assertEquals((double)(3.0 * Math.sqrt(2.0)), (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(4L, 4L);
        Assertions.assertEquals((double)(4.0 * Math.sqrt(2.0)), (double)val.getPowerDouble(), (double)1.0E-13);
        val = new BigComplex(7L, -3L);
        Assertions.assertEquals((double)Math.sqrt(58.0), (double)val.getPowerDouble(), (double)1.0E-13);
    }
}

