/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.saca;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Localizables;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import org.scijava.ops.image.coloc.saca.WtKendallTau;
import org.scijava.progress.Progress;

public final class AdaptiveSmoothedKendallTau {
    private AdaptiveSmoothedKendallTau() {
    }

    public static <I extends RealType<I>> void execute(RandomAccessibleInterval<I> image1, RandomAccessibleInterval<I> image2, RandomAccessibleInterval<DoubleType> result, I thres1, I thres2, long seed) {
        int s;
        long nr = image1.dimension(1);
        long nc = image1.dimension(0);
        ImgFactory factory = Util.getSuitableImgFactory(image1, (Object)new DoubleType());
        Img oldtau = factory.create(image1);
        Img newtau = factory.create(image1);
        Img oldsqrtN = factory.create(image1);
        Img newsqrtN = factory.create(image1);
        ArrayList<RandomAccessibleInterval<DoubleType>> stop = new ArrayList<RandomAccessibleInterval<DoubleType>>();
        double Dn = Math.sqrt(Math.log(nr * nc)) * 2.0;
        int TU = 15;
        int TL = 8;
        double Lambda = Dn;
        double stepsize = 1.15;
        Random rng = new Random(seed);
        boolean isCheck = false;
        double size = 1.0;
        for (s = 0; s < 3; ++s) {
            stop.add((RandomAccessibleInterval<DoubleType>)factory.create(image1));
        }
        LoopBuilder.setImages((RandomAccessibleInterval)oldsqrtN).multiThreaded().forEachPixel(t -> t.setOne());
        Progress.defineTotal((long)15L);
        for (s = 0; s < 15; ++s) {
            int intSize = (int)Math.floor(size);
            AdaptiveSmoothedKendallTau.singleiteration(image1, image2, thres1, thres2, stop, (RandomAccessibleInterval<DoubleType>)oldtau, (RandomAccessibleInterval<DoubleType>)oldsqrtN, (RandomAccessibleInterval<DoubleType>)newtau, (RandomAccessibleInterval<DoubleType>)newsqrtN, result, Lambda, Dn, intSize, isCheck, rng);
            size *= 1.15;
            if (s == 8) {
                isCheck = true;
                LoopBuilder.setImages((RandomAccessibleInterval)((RandomAccessibleInterval)stop.get(1)), (RandomAccessibleInterval)((RandomAccessibleInterval)stop.get(2)), (RandomAccessibleInterval)newtau, (RandomAccessibleInterval)newsqrtN).multiThreaded().forEachPixel((ts1, ts2, tTau, tSqrtN) -> {
                    ts1.set((AbstractRealType)tTau);
                    ts2.set((AbstractRealType)tSqrtN);
                });
            }
            Progress.update();
        }
    }

    private static <I extends RealType<I>> void singleiteration(RandomAccessibleInterval<I> image1, RandomAccessibleInterval<I> image2, I thres1, I thres2, List<RandomAccessibleInterval<DoubleType>> stop, RandomAccessibleInterval<DoubleType> oldtau, RandomAccessibleInterval<DoubleType> oldsqrtN, RandomAccessibleInterval<DoubleType> newtau, RandomAccessibleInterval<DoubleType> newsqrtN, RandomAccessibleInterval<DoubleType> result, double Lambda, double Dn, int Bsize, boolean isCheck, Random rng) {
        double[][] kernel = AdaptiveSmoothedKendallTau.kernelGenerate(Bsize);
        RandomAccessibleInterval workingImageStack = Views.stack((RandomAccessibleInterval[])new RandomAccessibleInterval[]{oldtau, newtau, oldsqrtN, newsqrtN, stop.get(0), stop.get(1), stop.get(2)});
        CompositeIntervalView workingImage = Views.collapse((RandomAccessibleInterval)workingImageStack);
        IntervalView positions = Views.interval((RandomAccessible)Localizables.randomAccessible((int)result.numDimensions()), result);
        LoopBuilder.setImages((RandomAccessibleInterval)positions, result, (RandomAccessibleInterval)workingImage).forEachChunk(chunk -> {
            long[] rowrange = new long[4];
            long[] colrange = new long[4];
            int totnum = (2 * Bsize + 1) * (2 * Bsize + 1);
            double[] LocX = new double[totnum];
            double[] LocY = new double[totnum];
            double[] LocW = new double[totnum];
            double[][] combinedData = new double[totnum][3];
            int[] rankedindex = new int[totnum];
            double[] rankedw = new double[totnum];
            int[] index1 = new int[totnum];
            int[] index2 = new int[totnum];
            double[] w1 = new double[totnum];
            double[] w2 = new double[totnum];
            double[] cumw = new double[totnum];
            long nr = result.dimension(1);
            long nc = result.dimension(0);
            RandomAccess gdImage1 = image1.randomAccess();
            RandomAccess gdImage2 = image2.randomAccess();
            RandomAccess gdTau = oldtau.randomAccess();
            RandomAccess gdSqrtN = oldsqrtN.randomAccess();
            chunk.forEachPixel((pos, resPixel, workingPixel) -> {
                double taudiff;
                DoubleType oldtauPix = (DoubleType)workingPixel.get(0L);
                DoubleType newtauPix = (DoubleType)workingPixel.get(1L);
                DoubleType oldsqrtNPix = (DoubleType)workingPixel.get(2L);
                DoubleType newsqrtNPix = (DoubleType)workingPixel.get(3L);
                DoubleType stop0Pix = (DoubleType)workingPixel.get(4L);
                DoubleType stop1Pix = (DoubleType)workingPixel.get(5L);
                DoubleType stop2Pix = (DoubleType)workingPixel.get(6L);
                long row = pos.getLongPosition(1);
                AdaptiveSmoothedKendallTau.updateRange(row, Bsize, nr, rowrange);
                if (isCheck && stop0Pix.getRealDouble() != 0.0) {
                    return;
                }
                long col = pos.getLongPosition(0);
                AdaptiveSmoothedKendallTau.updateRange(col, Bsize, nc, colrange);
                AdaptiveSmoothedKendallTau.getData(Dn, kernel, gdImage1, gdImage2, gdTau, gdSqrtN, LocX, LocY, LocW, rowrange, colrange, totnum);
                newsqrtNPix.setReal(Math.sqrt(AdaptiveSmoothedKendallTau.NTau(thres1, thres2, LocW, LocX, LocY)));
                if (newsqrtNPix.getRealDouble() <= 0.0) {
                    newtauPix.setZero();
                    resPixel.setZero();
                } else {
                    double tau = WtKendallTau.calculate(LocX, LocY, LocW, combinedData, rankedindex, rankedw, index1, index2, w1, w2, cumw, rng);
                    newtauPix.setReal(tau);
                    resPixel.setReal(tau * newsqrtNPix.getRealDouble() * 1.5);
                }
                if (isCheck && (taudiff = Math.abs(stop1Pix.getRealDouble() - newtauPix.getRealDouble()) * stop2Pix.getRealDouble()) > Lambda) {
                    stop0Pix.setOne();
                    newtauPix.set((AbstractRealType)oldtauPix);
                    newsqrtNPix.set((AbstractRealType)oldsqrtNPix);
                }
            });
            return null;
        });
        LoopBuilder.setImages(oldtau, newtau, oldsqrtN, newsqrtN).multiThreaded().forEachPixel((tOldTau, tNewTau, tOldSqrtN, tNewSqrtN) -> {
            tOldTau.set((AbstractRealType)tNewTau);
            tOldSqrtN.set((AbstractRealType)tNewSqrtN);
        });
    }

    private static <I extends RealType<I>, T extends RealType<T>> void getData(double Dn, double[][] w, RandomAccess<I> i1RA, RandomAccess<I> i2RA, RandomAccess<T> tau, RandomAccess<T> sqrtN, double[] sx, double[] sy, double[] sw, long[] rowrange, long[] colrange, int totnum) {
        int kernelk = (int)(rowrange[0] - rowrange[2] + rowrange[3]);
        int index = 0;
        sqrtN.setPosition(colrange[2], 0);
        sqrtN.setPosition(rowrange[2], 1);
        double sqrtNValue = ((RealType)sqrtN.get()).getRealDouble();
        for (long k = rowrange[0]; k <= rowrange[1]; ++k) {
            i1RA.setPosition(k, 1);
            i2RA.setPosition(k, 1);
            sqrtN.setPosition(k, 1);
            int kernell = (int)(colrange[0] - colrange[2] + colrange[3]);
            for (long l = colrange[0]; l <= colrange[1]; ++l) {
                i1RA.setPosition(l, 0);
                i2RA.setPosition(l, 0);
                sqrtN.setPosition(l, 0);
                sx[index] = ((RealType)i1RA.get()).getRealDouble();
                sy[index] = ((RealType)i2RA.get()).getRealDouble();
                sw[index] = w[kernelk][kernell];
                tau.setPosition(l, 0);
                tau.setPosition(k, 1);
                double tau1 = ((RealType)tau.get()).getRealDouble();
                tau.setPosition(colrange[2], 0);
                tau.setPosition(rowrange[2], 1);
                double tau2 = ((RealType)tau.get()).getRealDouble();
                double taudiffabs = Math.abs(tau1 - tau2) * sqrtNValue;
                sw[index] = taudiffabs < 1.0 ? sw[index] * (1.0 - (taudiffabs /= Dn)) * (1.0 - taudiffabs) : sw[index] * 0.0;
                ++kernell;
                ++index;
            }
            ++kernelk;
        }
        while (index < totnum) {
            sx[index] = 0.0;
            sy[index] = 0.0;
            sw[index] = 0.0;
            ++index;
        }
    }

    private static void updateRange(long location, int radius, long boundary, long[] range) {
        range[0] = location - (long)radius;
        if (range[0] < 0L) {
            range[0] = 0L;
        }
        range[1] = location + (long)radius;
        if (range[1] >= boundary) {
            range[1] = boundary - 1L;
        }
        range[2] = location;
        range[3] = radius;
    }

    private static <I extends RealType<I>> double NTau(I thres1, I thres2, double[] w, double[] x, double[] y) {
        double sumW = 0.0;
        double sumsqrtW = 0.0;
        for (int index = 0; index < w.length; ++index) {
            if (x[index] < thres1.getRealDouble() || y[index] < thres2.getRealDouble()) {
                w[index] = 0.0;
            }
            double tempW = w[index];
            sumW += tempW;
            sumsqrtW += (tempW *= w[index]);
        }
        double Denomi = sumW * sumW;
        double NW = Denomi <= 0.0 ? 0.0 : Denomi / sumsqrtW;
        return NW;
    }

    private static double[][] kernelGenerate(int size) {
        int L = size * 2 + 1;
        double[][] kernel = new double[L][L];
        int center = size;
        double Rsize = (double)size * Math.sqrt(2.5);
        for (int i = 0; i <= size; ++i) {
            for (int j = 0; j <= size; ++j) {
                double temp = Math.sqrt(i * i + j * j) / Rsize;
                temp = temp >= 1.0 ? 0.0 : 1.0 - temp;
                kernel[center + i][center + j] = temp;
                kernel[center - i][center + j] = temp;
                kernel[center + i][center - j] = temp;
                kernel[center - i][center - j] = temp;
            }
        }
        return kernel;
    }
}

