/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ops.image.features.haralick.AbstractHaralickFeature;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;
import org.scijava.ops.spi.OpDependency;

public class DefaultDifferenceVariance<T extends RealType<T>>
extends AbstractHaralickFeature<T> {
    @OpDependency(name="features.haralick.coocPXMinusY")
    private Function<double[][], double[]> coocPXMinusYFunc;

    public DoubleType apply(RandomAccessibleInterval<T> input, Integer numGreyLevels, Integer distance, MatrixOrientation orientation) {
        double[][] matrix = this.getCooccurrenceMatrix(input, numGreyLevels, distance, orientation);
        double[] pxminusy = this.coocPXMinusYFunc.apply(matrix);
        double mu = 0.0;
        for (int i = 0; i < numGreyLevels; ++i) {
            mu += (double)i * pxminusy[i];
        }
        double sum = 0.0;
        for (int k = 0; k < numGreyLevels; ++k) {
            sum += Math.pow((double)k - mu, 2.0) * pxminusy[k];
        }
        DoubleType output = new DoubleType();
        output.set(sum);
        return output;
    }
}

