/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.fft;

import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class FFTMethodsOpF<T extends RealType<T>, C extends ComplexType<C>>
implements Functions.Arity4<RandomAccessibleInterval<T>, C, long[], Boolean, RandomAccessibleInterval<C>> {
    @OpDependency(name="filter.padInputFFTMethods")
    private Functions.Arity4<RandomAccessibleInterval<T>, Dimensions, Boolean, OutOfBoundsFactory<T, RandomAccessibleInterval<T>>, RandomAccessibleInterval<T>> padOp;
    @OpDependency(name="filter.createFFTOutput")
    private Functions.Arity3<Dimensions, C, Boolean, RandomAccessibleInterval<C>> createOp;
    @OpDependency(name="filter.fft")
    private Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<C>> fftMethodsOp;

    public RandomAccessibleInterval<C> apply(RandomAccessibleInterval<T> input, C fftType, @Nullable long[] borderSize, @Nullable Boolean fast) {
        if (fast == null) {
            fast = true;
        }
        long[] paddedSize = new long[input.numDimensions()];
        for (int d = 0; d < input.numDimensions(); ++d) {
            paddedSize[d] = input.dimension(d);
            if (borderSize == null) continue;
            int n = d;
            paddedSize[n] = paddedSize[n] + borderSize[d];
        }
        FinalDimensions paddedDimensions = new FinalDimensions(paddedSize);
        RandomAccessibleInterval output = (RandomAccessibleInterval)this.createOp.apply((Object)paddedDimensions, fftType, (Object)fast);
        RandomAccessibleInterval paddedInput = (RandomAccessibleInterval)this.padOp.apply(input, (Object)paddedDimensions, (Object)fast, null);
        this.fftMethodsOp.compute((Object)paddedInput, (Object)output);
        return output;
    }
}

