/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.fftSize;

import java.util.Arrays;
import net.imglib2.Dimensions;
import net.imglib2.algorithm.fft2.FFTMethods;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.scijava.function.Functions;

public class ComputeFFTSize
implements Functions.Arity5<Dimensions, long[], long[], Boolean, Boolean, Pair<long[], long[]>> {
    public Pair<long[], long[]> apply(Dimensions inputDimensions, long[] paddedSize, long[] fftSize, Boolean forward, Boolean fast) {
        long[] paddedOutput = Arrays.copyOf(paddedSize, paddedSize.length);
        long[] fftOutput = Arrays.copyOf(fftSize, fftSize.length);
        if (fast.booleanValue() && forward.booleanValue()) {
            FFTMethods.dimensionsRealToComplexFast((Dimensions)inputDimensions, (long[])paddedOutput, (long[])fftOutput);
        } else if (!fast.booleanValue() && forward.booleanValue()) {
            FFTMethods.dimensionsRealToComplexSmall((Dimensions)inputDimensions, (long[])paddedOutput, (long[])fftOutput);
        }
        if (fast.booleanValue() && !forward.booleanValue()) {
            FFTMethods.dimensionsComplexToRealFast((Dimensions)inputDimensions, (long[])paddedOutput, (long[])fftOutput);
        } else if (!fast.booleanValue() && !forward.booleanValue()) {
            FFTMethods.dimensionsComplexToRealSmall((Dimensions)inputDimensions, (long[])paddedOutput, (long[])fftOutput);
        }
        return new ValuePair((Object)paddedOutput, (Object)fftOutput);
    }
}

