/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom3d;

import java.util.List;
import org.scijava.ops.image.geom.geom3d.Vertex;

abstract class UpdateablePointSet<T> {
    protected List<Vertex> vertices;
    protected List<T> neighbors;

    UpdateablePointSet() {
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public int indexOfVertex(Vertex vertex) {
        return this.vertices.indexOf((Object)vertex);
    }

    public Vertex getVertex(int i) {
        return this.vertices.get(i);
    }

    public int size() {
        return this.vertices.size();
    }

    public Vertex getLastVertex() {
        return this.vertices.get(this.vertices.size() - 1);
    }

    public boolean containsAll(List<Vertex> vertexList) {
        return this.vertices.containsAll(vertexList);
    }

    public boolean hasEdge(Vertex tail, Vertex head) {
        int start = this.vertices.indexOf((Object)tail);
        int end = this.vertices.indexOf((Object)head);
        if (start == -1 || end == -1) {
            return false;
        }
        return (start + 1) % this.vertices.size() == end;
    }

    public void setNeighbor(int position, T n) {
        this.neighbors.add(position, n);
    }

    public T getNeighbor(int position) {
        return this.neighbors.get(position);
    }

    public List<T> getNeighbors() {
        return this.neighbors;
    }

    public void replaceNeighbor(int i, T f) {
        this.neighbors.remove(i);
        this.neighbors.add(i, f);
    }

    public int indexOfNeighbor(T facet) {
        return this.neighbors.indexOf(facet);
    }
}

