/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.ascii;

import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import org.scijava.function.Functions;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class DefaultASCII<T extends RealType<T>>
implements Functions.Arity3<IterableInterval<T>, T, T, String> {
    private static final String CHARS = "#O*o+-,. ";
    @OpDependency(name="stats.minMax")
    private Function<IterableInterval<T>, Pair<T, T>> minMaxFunc;

    public String apply(IterableInterval<T> input, @Nullable T min, @Nullable T max) {
        if (min == null || max == null) {
            Pair<T, T> minMax = this.minMaxFunc.apply(input);
            if (min == null) {
                min = (RealType)minMax.getA();
            }
            if (max == null) {
                max = (RealType)minMax.getB();
            }
        }
        return DefaultASCII.ascii(input, min, max);
    }

    public static <T extends RealType<T>> String ascii(IterableInterval<T> image, T min, T max) {
        long dim0 = image.dimension(0);
        long dim1 = image.dimension(1);
        int w = (int)(dim0 + 1L);
        int h = (int)dim1;
        RealType span = (RealType)max.copy();
        span.sub(min);
        char[] c = new char[w * h];
        for (int y = 1; y <= h; ++y) {
            c[w * y - 1] = 10;
        }
        Cursor cursor = image.localizingCursor();
        int[] pos = new int[image.numDimensions()];
        RealType tmp = (RealType)((RealType)image.firstElement()).copy();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(pos);
            int index = w * pos[1] + pos[0];
            tmp.set((Type)((RealType)cursor.get()));
            tmp.sub(min);
            double normalized = tmp.getRealDouble() / span.getRealDouble();
            int charLen = CHARS.length();
            int charIndex = (int)((double)charLen * normalized);
            c[index] = CHARS.charAt(charIndex < charLen ? charIndex : charLen - 1);
        }
        return new String(c);
    }
}

