/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import java.util.ArrayList;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;
import org.scijava.concurrent.Parallelization;
import org.scijava.ops.image.image.distancetransform.Phase1Runnable2D;
import org.scijava.ops.image.image.distancetransform.Phase2Runnable2D;

public final class DistanceTransform2D {
    private DistanceTransform2D() {
    }

    public static <B extends BooleanType<B>, T extends RealType<T>> void compute(RandomAccessibleInterval<B> in, RandomAccessibleInterval<T> out) {
        int[][] tempValues = new int[(int)in.dimension(0)][(int)out.dimension(1)];
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        int y = 0;
        while ((long)y < in.dimension(1)) {
            list.add(new Phase1Runnable2D<B>(tempValues, in, y));
            ++y;
        }
        Parallelization.getTaskExecutor().runAll(list);
        list.clear();
        int x = 0;
        while ((long)x < in.dimension(0)) {
            list.add(new Phase2Runnable2D<T>(tempValues, out, x));
            ++x;
        }
        Parallelization.getTaskExecutor().runAll(list);
    }
}

