/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.integral;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converters;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.function.Computers;

public abstract class AbstractIntegralImg<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>> {
    public final Computers.Arity1<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> computeAdd = (input, output) -> {
        Cursor inputCursor = Views.iterable((RandomAccessibleInterval)input).cursor();
        Cursor outputCursor = Views.iterable((RandomAccessibleInterval)output).cursor();
        double tmp = 0.0;
        while (outputCursor.hasNext()) {
            RealType inputValue = (RealType)inputCursor.next();
            RealType outputValue = (RealType)outputCursor.next();
            outputValue.setReal(tmp += inputValue.getRealDouble());
        }
    };
    public final Computers.Arity1<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> computeSquareAndAdd = (input, output) -> {
        Cursor inputCursor = Views.iterable((RandomAccessibleInterval)input).cursor();
        Cursor outputCursor = Views.iterable((RandomAccessibleInterval)output).cursor();
        double tmp = 0.0;
        while (outputCursor.hasNext()) {
            RealType inputValue = (RealType)inputCursor.next();
            RealType outputValue = (RealType)outputCursor.next();
            outputValue.setReal(tmp += Math.pow(inputValue.getRealDouble(), 2.0));
        }
    };

    public void compute(RandomAccessibleInterval<I> input, RandomAccessibleInterval<O> output) {
        if (!Views.iterable(input).iterationOrder().equals(Views.iterable(output).iterationOrder())) {
            throw new IllegalArgumentException("Input and Output images must have the same iteration order!");
        }
        RandomAccessibleInterval<O> generalizedInput = Converters.convert(input, (arg0, arg1) -> arg1.setReal(arg0.getRealDouble()), (Type)((RealType)((RealType)Views.iterable(output).firstElement()).createVariable()));
        for (int i = 0; i < input.numDimensions(); ++i) {
            int j = 0;
            while ((long)j < input.dimension(i)) {
                this.getComputer(i).compute((Object)Views.hyperSlice(generalizedInput, (int)i, (long)j), (Object)Views.hyperSlice(output, (int)i, (long)j));
                ++j;
            }
            generalizedInput = output;
        }
    }

    public abstract Computers.Arity1<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> getComputer(int var1);
}

