/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.watershed;

import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class WatershedBinarySingleSigma<T extends BooleanType<T>, B extends BooleanType<B>>
implements Computers.Arity5<RandomAccessibleInterval<T>, Boolean, Boolean, Double, RandomAccessibleInterval<B>, ImgLabeling<Integer, IntType>> {
    @OpDependency(name="image.distanceTransform")
    private Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<FloatType>> distanceTransformer;
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, FloatType, RandomAccessibleInterval<FloatType>> imgCreator;
    @OpDependency(name="image.invert")
    private Computers.Arity1<RandomAccessibleInterval<FloatType>, RandomAccessibleInterval<FloatType>> imgInverter;
    @OpDependency(name="filter.gauss")
    private Computers.Arity2<RandomAccessibleInterval<FloatType>, Double, RandomAccessibleInterval<FloatType>> gaussOp;
    @OpDependency(name="image.watershed")
    private Computers.Arity4<RandomAccessibleInterval<FloatType>, Boolean, Boolean, RandomAccessibleInterval<B>, ImgLabeling<Integer, IntType>> watershedOp;

    public void compute(RandomAccessibleInterval<T> in, Boolean useEightConnectivity, Boolean drawWatersheds, Double sigma, @Nullable RandomAccessibleInterval<B> mask, ImgLabeling<Integer, IntType> outputLabeling) {
        boolean conformed;
        boolean bl = conformed = sigma >= 0.0;
        if (!conformed) {
            throw new IllegalArgumentException("sigma must be non-negative!");
        }
        if (mask != null) {
            conformed &= Intervals.equalDimensions(mask, in);
        }
        if (!conformed) {
            throw new IllegalArgumentException("mask must be of the same dimensions as the input!");
        }
        RandomAccessibleInterval<FloatType> distMap = this.imgCreator.apply((Dimensions)in, new FloatType());
        this.distanceTransformer.compute(in, distMap);
        RandomAccessibleInterval<FloatType> invertedDT = this.imgCreator.apply((Dimensions)in, new FloatType());
        this.imgInverter.compute(distMap, invertedDT);
        RandomAccessibleInterval<FloatType> gauss = this.imgCreator.apply((Dimensions)in, new FloatType());
        this.gaussOp.compute(invertedDT, (Object)sigma, gauss);
        this.watershedOp.compute(gauss, (Object)useEightConnectivity, (Object)drawWatersheds, mask, outputLabeling);
    }
}

