/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.watershed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.DiamondShape;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Regions;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.BooleanType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class WatershedSeeded<T extends RealType<T>, B extends BooleanType<B>>
implements Computers.Arity5<RandomAccessibleInterval<T>, ImgLabeling<Integer, IntType>, Boolean, Boolean, RandomAccessibleInterval<B>, ImgLabeling<Integer, IntType>> {
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, BitType, RandomAccessibleInterval<BitType>> imgCreator;
    private static final int WSHED = -1;
    private static final int INIT = -2;
    private static final int INQUEUE = -3;
    private static final int OUTSIDE = -4;
    private static final AtomicLong seq = new AtomicLong();

    public void compute(RandomAccessibleInterval<T> in, ImgLabeling<Integer, IntType> seeds, Boolean useEightConnectivity, Boolean drawWatersheds, @Nullable RandomAccessibleInterval<B> maskInput, ImgLabeling<Integer, IntType> out) {
        boolean conformed = true;
        if (maskInput != null) {
            conformed = Intervals.equalDimensions(maskInput, in);
        }
        if (!conformed) {
            throw new IllegalArgumentException("maskInput must be of the same size as the input");
        }
        if (!(conformed &= Intervals.equalDimensions(seeds, in))) {
            throw new IllegalArgumentException("seed labeling must be of the same size as the input");
        }
        LabelingType outside = out.firstElement().copy();
        outside.clear();
        outside.add((Object)-4);
        ExtendedRandomAccessibleInterval outExt = Views.extendValue(out, (Type)outside);
        OutOfBounds raOut = outExt.randomAccess();
        Object mask = maskInput;
        if (mask == null) {
            mask = this.imgCreator.apply((Dimensions)in, new BitType());
            for (BooleanType b : Views.flatIterable(mask)) {
                b.set(true);
            }
        }
        Cursor maskCursor = Views.flatIterable(mask).cursor();
        while (maskCursor.hasNext()) {
            maskCursor.fwd();
            if (!((BooleanType)maskCursor.get()).get()) continue;
            raOut.setPosition((Localizable)maskCursor);
            ((LabelingType)raOut.get()).clear();
            ((LabelingType)raOut.get()).add((Object)-2);
        }
        RandomAccess raMask = mask.randomAccess();
        RandomAccess raSeeds = seeds.randomAccess();
        Object shape = useEightConnectivity != false ? new RectangleShape(1, true) : new DiamondShape(1L);
        RandomAccessible neighborhoods = shape.neighborhoodsRandomAccessible(in);
        RandomAccess raNeigh = neighborhoods.randomAccess();
        PriorityQueue<WatershedVoxel> pq = new PriorityQueue<WatershedVoxel>();
        IterableRegion maskRegions = Regions.iterable(mask);
        IterableInterval seedsMasked = Regions.sample((IterableInterval)maskRegions, seeds);
        Cursor cursorSeeds = seedsMasked.localizingCursor();
        while (cursorSeeds.hasNext()) {
            Set l = (Set)cursorSeeds.next();
            if (l.isEmpty()) continue;
            if (l.size() > 1) {
                throw new IllegalArgumentException("Seeds must have exactly one label!");
            }
            Integer label = (Integer)l.iterator().next();
            if (label < 0) {
                throw new IllegalArgumentException("Seeds must have positive integers as labels!");
            }
            raNeigh.setPosition((Localizable)cursorSeeds);
            Cursor neighborhood = ((Neighborhood)raNeigh.get()).cursor();
            while (neighborhood.hasNext()) {
                neighborhood.fwd();
                raSeeds.setPosition((Localizable)neighborhood);
                raMask.setPosition((Localizable)neighborhood);
                raOut.setPosition((Localizable)neighborhood);
                Integer labelNeigh = (Integer)((LabelingType)raOut.get()).iterator().next();
                if (labelNeigh == -3 || labelNeigh == -4 || raOut.isOutOfBounds() || !((BooleanType)raMask.get()).get() || !((LabelingType)raSeeds.get()).isEmpty()) continue;
                raOut.setPosition((Localizable)neighborhood);
                pq.add(new WatershedVoxel(IntervalIndexer.positionToIndex((Localizable)neighborhood, in), ((RealType)neighborhood.get()).getRealDouble()));
                ((LabelingType)raOut.get()).clear();
                ((LabelingType)raOut.get()).add((Object)-3);
            }
            raOut.setPosition((Localizable)cursorSeeds);
            ((LabelingType)raOut.get()).clear();
            ((LabelingType)raOut.get()).add((Object)label);
        }
        ArrayList<Object> neighborLabels = new ArrayList<Object>();
        ArrayList<WatershedVoxel> neighborVoxels = new ArrayList<WatershedVoxel>();
        Point pos = new Point(in.numDimensions());
        while (!pq.isEmpty()) {
            IntervalIndexer.indexToPosition((long)((WatershedVoxel)pq.poll()).getPos(), out, (Positionable)pos);
            neighborLabels.clear();
            neighborVoxels.clear();
            raNeigh.setPosition((Localizable)pos);
            Cursor neighborhood = ((Neighborhood)raNeigh.get()).cursor();
            while (neighborhood.hasNext()) {
                neighborhood.fwd();
                raOut.setPosition((Localizable)neighborhood);
                raMask.setPosition((Localizable)raOut);
                if (((LabelingType)raOut.get()).isEmpty()) continue;
                Integer label = (Integer)((LabelingType)raOut.get()).iterator().next();
                if (label == -2 && ((BooleanType)raMask.get()).get()) {
                    neighborVoxels.add(new WatershedVoxel(IntervalIndexer.positionToIndex((Localizable)neighborhood, out), ((RealType)neighborhood.get()).getRealDouble()));
                    continue;
                }
                if (label <= -1 || drawWatersheds.booleanValue() && neighborLabels.contains(label)) continue;
                neighborLabels.add(label);
            }
            if (drawWatersheds.booleanValue()) {
                raOut.setPosition((Localizable)pos);
                ((LabelingType)raOut.get()).clear();
                if (neighborLabels.size() == 1) {
                    ((LabelingType)raOut.get()).add((Object)((Integer)neighborLabels.get(0)));
                    for (WatershedVoxel v : neighborVoxels) {
                        IntervalIndexer.indexToPosition((long)v.getPos(), out, (Positionable)raOut);
                        ((LabelingType)raOut.get()).clear();
                        ((LabelingType)raOut.get()).add((Object)-3);
                        pq.add(v);
                    }
                    continue;
                }
                if (neighborLabels.size() <= 1) continue;
                ((LabelingType)raOut.get()).add((Object)-1);
                continue;
            }
            if (neighborLabels.size() <= 0) continue;
            raOut.setPosition((Localizable)pos);
            ((LabelingType)raOut.get()).clear();
            if (neighborLabels.size() > 2) {
                Map<Integer, Long> countLabels = neighborLabels.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting()));
                Integer keyMax = (Integer)Collections.max(countLabels.entrySet(), Comparator.comparingLong(Map.Entry::getValue)).getKey();
                ((LabelingType)raOut.get()).add((Object)keyMax);
            } else {
                ((LabelingType)raOut.get()).add((Object)((Integer)neighborLabels.get(0)));
            }
            for (WatershedVoxel v : neighborVoxels) {
                IntervalIndexer.indexToPosition((long)v.getPos(), out, (Positionable)raOut);
                ((LabelingType)raOut.get()).clear();
                ((LabelingType)raOut.get()).add((Object)-3);
                pq.add(v);
            }
        }
        if (out != null) {
            Cursor cursor = out.cursor();
            while (cursor.hasNext()) {
                cursor.fwd();
                raOut.setPosition((Localizable)cursor);
                ArrayList labels = new ArrayList();
                ((LabelingType)cursor.get()).iterator().forEachRemaining(labels::add);
                ((LabelingType)raOut.get()).addAll(labels);
            }
        }
    }

    class WatershedVoxel
    implements Comparable<WatershedVoxel> {
        private final long pos;
        private final double value;
        private final long seqNum;

        public WatershedVoxel(long pos, double value) {
            this.pos = pos;
            this.value = value;
            this.seqNum = seq.getAndIncrement();
        }

        public long getPos() {
            return this.pos;
        }

        public double getValue() {
            return this.value;
        }

        @Override
        public int compareTo(WatershedVoxel o) {
            int res = Double.compare(this.value, o.value);
            if (res == 0) {
                res = this.seqNum < o.seqNum ? -1 : 1;
            }
            return res;
        }
    }
}

