/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.progress;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.progress.Progress;
import org.scijava.progress.Task;

public class ParallelProgressTest {
    public final Function<Integer, Integer> iterator = iterations -> {
        Progress.defineTotal((long)iterations.intValue());
        for (int i = 0; i < iterations; ++i) {
            Progress.update();
        }
        return iterations;
    };
    public final BiFunction<Integer, Integer, Integer> parallelProgressTask = (numThreads, iterationsPerThread) -> {
        int i;
        Progress.defineTotal((long)(numThreads * iterationsPerThread));
        Thread[] threadArr = new Thread[numThreads.intValue()];
        for (i = 0; i < numThreads; ++i) {
            threadArr[i] = new Thread(() -> {
                for (int j = 0; j < iterationsPerThread; ++j) {
                    Progress.update();
                }
            });
            threadArr[i].start();
        }
        try {
            for (i = 0; i < numThreads; ++i) {
                threadArr[i].join();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    };

    public static Integer parallelDepTask(Function<Integer, Integer> dep, Integer numThreads, Integer iterationsPerThread) {
        int i;
        Progress.defineTotal((long)0L, (long)numThreads.intValue());
        Thread[] threadArr = new Thread[numThreads.intValue()];
        for (i = 0; i < numThreads; ++i) {
            threadArr[i] = new Thread(() -> {
                Progress.register((Object)dep);
                dep.apply(iterationsPerThread);
                Progress.complete();
            });
            threadArr[i].start();
        }
        try {
            for (i = 0; i < numThreads; ++i) {
                threadArr[i].join();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return numThreads * iterationsPerThread;
    }

    @Test
    public void testParallelProgressUpdating() {
        BiFunction<Integer, Integer, Integer> task = this.parallelProgressTask;
        int numThreads = 4;
        int iterationsPerThread = 1000;
        Progress.addListener(task, (Consumer)new Consumer<Task>(){
            double lastProgress = 0.0;

            @Override
            public void accept(Task t) {
                double progress = t.progress();
                Assertions.assertTrue((this.lastProgress <= progress ? 1 : 0) != 0);
                this.lastProgress = progress;
            }
        });
        Progress.register(task);
        task.apply(numThreads, iterationsPerThread);
        Progress.complete();
    }

    @Test
    public void testParallelDependencyUpdating() {
        BiFunction<Integer, Integer, Integer> task = (in1, in2) -> ParallelProgressTest.parallelDepTask(this.iterator, in1, in2);
        int numThreads = 4;
        int iterationsPerThread = 1;
        Progress.addListener(task, (Consumer)new Consumer<Task>(){
            final ThreadLocal<List<Double>> lastProgress = ThreadLocal.withInitial(() -> {
                ArrayList<Double> a = new ArrayList<Double>();
                a.add(0.0);
                return a;
            });

            @Override
            public void accept(Task t) {
                List<Double> l = this.lastProgress.get();
                double progress = t.progress();
                double v = l.get(l.size() - 1) - progress;
                if (v > 0.0) {
                    t.progress();
                }
                Assertions.assertTrue((v <= 0.0 ? 1 : 0) != 0);
                l.add(progress);
            }
        });
        Progress.register(task);
        task.apply(numThreads, iterationsPerThread);
        Progress.complete();
    }
}

