/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core;

import java.util.concurrent.TimeUnit;
import org.sellcom.core.Contract;

public class Threads {
    private Threads() {
    }

    public static boolean checkInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    public static void interrupt() {
        Thread.currentThread().interrupt();
    }

    public static void preserveInterruptedStatus(InterruptedException e) {
        if (e != null) {
            Threads.interrupt();
        }
    }

    public static void sleep(long duration, TimeUnit unit) {
        Contract.checkArgument(duration >= 0L, "Duration must not be negative", new Object[0]);
        Contract.checkArgument(unit != null, "Unit must not be null", new Object[0]);
        try {
            Thread.sleep(unit.toMillis(duration));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

