/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.collection;

import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sellcom.core.Contract;

public class Iterables {
    private Iterables() {
    }

    public static <E> Iterable<E> emptyToNull(Iterable<E> iterable) {
        return Iterables.isNullOrEmpty(iterable) ? null : iterable;
    }

    public static boolean isNullOrEmpty(Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static <E> Iterable<E> nullToEmpty(Iterable<E> iterable) {
        return Iterables.isNullOrEmpty(iterable) ? Collections.emptyList() : iterable;
    }

    public static <E> Stream<E> parallelStream(Iterable<E> iterable) {
        Contract.checkArgument(iterable != null, "Iterable must not be null", new Object[0]);
        return StreamSupport.stream(iterable.spliterator(), true);
    }

    public static <E> Stream<E> stream(Iterable<E> iterable) {
        Contract.checkArgument(iterable != null, "Iterable must not be null", new Object[0]);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <E> List<E> toList(Iterable<E> elements) {
        Contract.checkArgument(elements != null, "Elements must not be null", new Object[0]);
        if (elements instanceof List) {
            return (List)elements;
        }
        return Iterables.stream(elements).collect(Collectors.toList());
    }

    public static <E> NavigableSet<E> toNavigableSet(Iterable<E> elements) {
        Contract.checkArgument(elements != null, "Elements must not be null", new Object[0]);
        if (elements instanceof NavigableSet) {
            return (NavigableSet)elements;
        }
        return Iterables.stream(elements).collect(Collectors.toCollection(TreeSet::new));
    }

    public static <E> Set<E> toSet(Iterable<E> elements) {
        Contract.checkArgument(elements != null, "Elements must not be null", new Object[0]);
        if (elements instanceof Set) {
            return (Set)elements;
        }
        return Iterables.stream(elements).collect(Collectors.toSet());
    }
}

