/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.util.ArrayUtils;
import org.sellcom.core.util.MoreArrays;

public class SparseArray<E>
implements Cloneable {
    private static final int DEFAULT_CAPACITY = 10;
    private Object[] elements;
    private int[] indices;
    private int size;

    public SparseArray() {
        this(10);
    }

    public SparseArray(int initialCapacity) {
        this.elements = new Object[initialCapacity];
        this.indices = new int[initialCapacity];
        this.size = 0;
    }

    public void clear() {
        this.size = 0;
    }

    public SparseArray<E> clone() {
        SparseArray clone = null;
        try {
            clone = (SparseArray)super.clone();
            clone.elements = (Object[])this.elements.clone();
            clone.indices = (int[])this.indices.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public boolean containsElement(E element) {
        Contract.checkArgument(element != null, "Element must not be null", new Object[0]);
        return MoreArrays.indexOf(this.elements, 0, this.size, element) >= 0;
    }

    public boolean containsIndex(int index) {
        Contract.checkArgument(index >= 0, "Index must not be negative: {0}", index);
        return Arrays.binarySearch(this.indices, 0, this.size, index) >= 0;
    }

    public void ensureCapacity(int minCapacity) {
        Contract.checkArgument(minCapacity >= 0, "Minimum capacity must not be negative: {0}", minCapacity);
        if (minCapacity > this.elements.length) {
            int targetCapacity = Math.max(minCapacity, 2 * this.elements.length);
            this.elements = Arrays.copyOf(this.elements, targetCapacity);
            this.indices = Arrays.copyOf(this.indices, targetCapacity);
        }
    }

    public void forEach(BiConsumer<Integer, ? super E> action) {
        Contract.checkArgument(action != null, "Action must not be null", new Object[0]);
        for (int i = 0; i < this.size; ++i) {
            action.accept(this.indices[i], this.elements[i]);
        }
    }

    public E get(int index) {
        return this.getOrDefault(index, null);
    }

    public E getOrDefault(int index, E defaultValue) {
        Contract.checkArgument(index >= 0, "Index must not be negative: {0}", index);
        int internalIndex = Arrays.binarySearch(this.indices, 0, this.size, index);
        if (internalIndex < 0) {
            return defaultValue;
        }
        return (E)this.elements[internalIndex];
    }

    public int indexOf(E element) {
        Contract.checkArgument(element != null, "Element must not be null", new Object[0]);
        int internalIndex = MoreArrays.indexOf(this.elements, 0, this.size, element);
        return internalIndex == -1 ? -1 : this.indices[internalIndex];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(E element) {
        Contract.checkArgument(element != null, "Element must not be null", new Object[0]);
        int internalIndex = MoreArrays.lastIndexOf(this.elements, 0, this.size, element);
        return internalIndex == -1 ? -1 : this.indices[internalIndex];
    }

    public E remove(int index) {
        Contract.checkArgument(index >= 0, "Index must not be negative: {0}", index);
        int internalIndex = Arrays.binarySearch(this.indices, 0, this.size, index);
        if (internalIndex < 0) {
            return null;
        }
        Object element = this.elements[internalIndex];
        ArrayUtils.shiftLeft(this.elements, internalIndex + 1, this.size);
        ArrayUtils.shiftLeft(this.indices, internalIndex + 1, this.size);
        --this.size;
        return (E)element;
    }

    public void set(int index, E value) {
        Contract.checkArgument(index >= 0, "Index must not be negative: {0}", index);
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        int internalIndex = Arrays.binarySearch(this.indices, 0, this.size, index);
        if (internalIndex < 0) {
            this.ensureCapacity(this.size + 1);
            internalIndex = -internalIndex - 1;
            ArrayUtils.shiftRight(this.elements, internalIndex, this.size);
            this.elements[internalIndex] = value;
            ArrayUtils.shiftRight(this.indices, internalIndex, this.size);
            this.indices[internalIndex] = index;
            ++this.size;
        } else {
            int elementIndex = this.indices[internalIndex];
            this.elements[elementIndex] = value;
        }
    }

    public void setIfAbsent(int index, E value) {
        Contract.checkArgument(index >= 0, "Index must not be negative: {0}", index);
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        int internalIndex = Arrays.binarySearch(this.indices, 0, this.size, index);
        if (internalIndex < 0) {
            this.ensureCapacity(this.size + 1);
            internalIndex = -internalIndex - 1;
            ArrayUtils.shiftRight(this.elements, internalIndex, this.size);
            this.elements[internalIndex] = value;
            ArrayUtils.shiftRight(this.indices, internalIndex, this.size);
            this.indices[internalIndex] = index;
            ++this.size;
        }
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        ArrayList<String> elementStrings = new ArrayList<String>(this.size);
        for (int i = 0; i < this.size; ++i) {
            elementStrings.add(String.format("[%d]=%s", this.indices[i], this.elements[i]));
        }
        return String.format("{%s}", String.join((CharSequence)", ", elementStrings));
    }

    public void trimToSize() {
        if (this.elements.length < this.size) {
            this.elements = Arrays.copyOf(this.elements, this.size);
            this.indices = Arrays.copyOf(this.indices, this.size);
        }
    }
}

