/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.i18n;

import java.util.Locale;
import org.sellcom.core.i18n.LocaleNotSupportedException;

class PluralizationRules {
    private static final String FEW = ".few";
    private static final String MANY = ".many";
    private static final String ONE = ".one";
    private static final String OTHER = ".other";
    private static final String TWO = ".two";
    private static final String ZERO = ".zero";

    private PluralizationRules() {
    }

    public static String getSuffix(Locale locale, String key, int quantity) {
        switch (locale.getLanguage()) {
            case "af": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "ar": {
                if (quantity == 0) {
                    return ZERO;
                }
                if (quantity == 1) {
                    return ONE;
                }
                if (quantity == 2) {
                    return TWO;
                }
                if (PluralizationRules.isInRange(quantity % 100, 3, 10)) {
                    return FEW;
                }
                if (quantity % 100 >= 11) {
                    return MANY;
                }
                return OTHER;
            }
            case "az": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "be": {
                if (quantity % 10 == 1 && quantity % 100 != 11) {
                    return ONE;
                }
                if (PluralizationRules.isInRange(quantity % 10, 2, 4) && !PluralizationRules.isInRange(quantity % 100, 12, 14)) {
                    return FEW;
                }
                return OTHER;
            }
            case "bg": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "bs": {
                if (quantity % 10 == 1 && quantity % 100 != 11) {
                    return ONE;
                }
                if (PluralizationRules.isInRange(quantity % 10, 2, 4) && !PluralizationRules.isInRange(quantity % 100, 12, 14)) {
                    return FEW;
                }
                return OTHER;
            }
            case "ca": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "cs": {
                if (quantity == 1) {
                    return ONE;
                }
                if (PluralizationRules.isInRange(quantity, 2, 4)) {
                    return FEW;
                }
                return OTHER;
            }
            case "da": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "de": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "el": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "en": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "eo": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "es": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "et": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "eu": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "fi": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "fo": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "fr": {
                if (quantity == 0 || quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "fy": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "gl": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "hr": {
                if (quantity % 10 == 1 && quantity % 100 != 11) {
                    return ONE;
                }
                if (PluralizationRules.isInRange(quantity % 10, 2, 4) && !PluralizationRules.isInRange(quantity % 100, 12, 14)) {
                    return FEW;
                }
                return OTHER;
            }
            case "hu": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "hy": {
                if (quantity == 0 || quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "is": {
                if (quantity % 10 == 1 && quantity % 100 != 11) {
                    return ONE;
                }
                return OTHER;
            }
            case "it": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "iu": {
                if (quantity == 1) {
                    return ONE;
                }
                if (quantity == 2) {
                    return TWO;
                }
                return OTHER;
            }
            case "iw": {
                if (quantity == 1) {
                    return ONE;
                }
                if (quantity == 2) {
                    return TWO;
                }
                if (quantity % 10 == 0 && quantity != 0) {
                    return MANY;
                }
                return OTHER;
            }
            case "ja": {
                return "";
            }
            case "ka": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "kk": {
                return "";
            }
            case "ko": {
                return "";
            }
            case "ky": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "la": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "lb": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "lt": {
                if (quantity % 10 == 1 && quantity % 100 != 11) {
                    return ONE;
                }
                if (quantity % 10 >= 2 && !PluralizationRules.isInRange(quantity % 100, 11, 19)) {
                    return ONE;
                }
                return OTHER;
            }
            case "lv": {
                if (quantity % 10 == 0 || PluralizationRules.isInRange(quantity % 100, 11, 19)) {
                    return ZERO;
                }
                if (quantity % 10 == 1 && quantity % 100 != 11) {
                    return ONE;
                }
                return OTHER;
            }
            case "mk": {
                if (quantity % 10 == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "mn": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "nb": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "nl": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "nn": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "pl": {
                if (quantity == 1) {
                    return ONE;
                }
                if (PluralizationRules.isInRange(quantity % 10, 2, 4) && !PluralizationRules.isInRange(quantity % 100, 12, 14)) {
                    return FEW;
                }
                return OTHER;
            }
            case "pt": {
                switch (locale.getCountry()) {
                    case "BR": {
                        if (quantity == 0 || quantity == 1) {
                            return ONE;
                        }
                        return OTHER;
                    }
                }
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "rm": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "ro": {
                if (quantity == 1) {
                    return ONE;
                }
                if (quantity == 0 || PluralizationRules.isInRange(quantity % 100, 1, 19)) {
                    return FEW;
                }
                return OTHER;
            }
            case "ru": {
                if (quantity % 10 == 1 && quantity % 100 != 11) {
                    return ONE;
                }
                if (PluralizationRules.isInRange(quantity % 10, 2, 4) && !PluralizationRules.isInRange(quantity % 100, 12, 14)) {
                    return FEW;
                }
                return OTHER;
            }
            case "se": {
                if (quantity == 1) {
                    return ONE;
                }
                if (quantity == 2) {
                    return TWO;
                }
                return OTHER;
            }
            case "sk": {
                if (quantity == 1) {
                    return ONE;
                }
                if (PluralizationRules.isInRange(quantity, 2, 4)) {
                    return FEW;
                }
                return OTHER;
            }
            case "sl": {
                if (quantity % 100 == 1) {
                    return ONE;
                }
                if (quantity % 100 == 2) {
                    return TWO;
                }
                if (PluralizationRules.isInRange(quantity % 100, 3, 4)) {
                    return FEW;
                }
                return OTHER;
            }
            case "sq": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "sr": {
                if (quantity % 10 == 1 && quantity % 100 != 11) {
                    return ONE;
                }
                if (PluralizationRules.isInRange(quantity % 10, 2, 4) && !PluralizationRules.isInRange(quantity % 100, 12, 14)) {
                    return FEW;
                }
                return OTHER;
            }
            case "sv": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "tk": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "tr": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "uk": {
                if (quantity % 10 == 1 && quantity % 100 != 11) {
                    return ONE;
                }
                if (PluralizationRules.isInRange(quantity % 10, 2, 4) && !PluralizationRules.isInRange(quantity % 100, 12, 14)) {
                    return FEW;
                }
                return OTHER;
            }
            case "uz": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "vi": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "wa": {
                if (quantity == 0 || quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "yi": {
                if (quantity == 1) {
                    return ONE;
                }
                return OTHER;
            }
            case "zh": {
                return "";
            }
        }
        throw new LocaleNotSupportedException(String.format("Locale not supported: %s", locale));
    }

    private static boolean isInRange(int n, int min, int max) {
        return n >= min && n <= max;
    }
}

