/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.util.MoreArrays;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T[] createArray(Class<T> type, int length) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        Contract.checkArgument(length >= 0, "Length must not be negative: {0}", length);
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] createArray(T[] reference, int length) {
        Contract.checkArgument(reference != null, "Reference must not be null", new Object[0]);
        return ReflectionUtils.createArray(reference.getClass().getComponentType(), length);
    }

    public static <T extends Exception> T createException(Class<T> type) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            return (T)((Exception)constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("Exception class %s is not instantiable", type.getSimpleName()), e);
        }
    }

    public static <T extends Exception> T createException(Class<T> type, String message) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        try {
            Constructor<T> constructor = type.getConstructor(String.class);
            return (T)((Exception)constructor.newInstance(message));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("Exception class %s is not instantiable", type.getSimpleName()), e);
        }
    }

    public static <T extends Exception> T createException(Class<T> type, String message, Throwable cause) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        try {
            Constructor<T> constructor = type.getConstructor(String.class, Throwable.class);
            return (T)((Exception)constructor.newInstance(message, cause));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("Exception class %s is not instantiable", type.getSimpleName()), e);
        }
    }

    public static <T extends Exception> T createException(Class<T> type, Throwable cause) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        try {
            Constructor<T> constructor = type.getConstructor(Throwable.class);
            return (T)((Exception)constructor.newInstance(cause));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("Exception class %s is not instantiable", type.getSimpleName()), e);
        }
    }

    public static void decrementClassFieldValue(Class<?> target, String fieldName) throws IllegalAccessException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(fieldName), "Field name must not be null or empty", new Object[0]);
        Field field = ReflectionUtils.findField(target, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(MessageFormat.format("Field \"{0}\" not found", fieldName));
        }
        ReflectionUtils.decrementFieldValue(null, field);
    }

    public static void decrementFieldValue(Object target, Field field) throws IllegalAccessException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(field != null, "Field must not be null", new Object[0]);
        Class<?> fieldType = field.getType();
        if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
            Integer value = (Integer)ReflectionUtils.getFieldValue(target, field);
            value = Math.decrementExact(value);
            ReflectionUtils.setFieldValue(target, field, value);
            return;
        }
        if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
            Long value = (Long)ReflectionUtils.getFieldValue(target, field);
            value = Math.decrementExact(value);
            ReflectionUtils.setFieldValue(target, field, value);
            return;
        }
        throw new IllegalArgumentException(MessageFormat.format("Field \"{0}\" is not of decrementable type", field.getName()));
    }

    public static void decrementInstanceFieldValue(Object target, String fieldName) throws IllegalAccessException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(fieldName), "Field name must not be null or empty", new Object[0]);
        Field field = ReflectionUtils.findField(target.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException(MessageFormat.format("Field \"{0}\" not found", fieldName));
        }
        ReflectionUtils.decrementFieldValue(target, field);
    }

    public static Field findField(Class<?> type, String fieldName) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(fieldName), "Field name must not be null or empty", new Object[0]);
        try {
            return type.getField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            do {
                Field[] declaredFields;
                for (Field field : declaredFields = type.getDeclaredFields()) {
                    if (!Objects.equals(field.getName(), fieldName)) continue;
                    return field;
                }
            } while ((type = type.getSuperclass()) != null);
            return null;
        }
    }

    public static Method findMethod(Class<?> type, String methodName, Class<?>[] parameterTypes) {
        Contract.checkArgument(type != null, "Type must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(methodName), "Method name must not be null or empty", new Object[0]);
        try {
            return type.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            parameterTypes = MoreArrays.nullToEmpty(parameterTypes);
            do {
                Method[] declaredMethods;
                for (Method method : declaredMethods = type.getDeclaredMethods()) {
                    if (!Objects.equals(method.getName(), methodName) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
                    return method;
                }
            } while ((type = type.getSuperclass()) != null);
            return null;
        }
    }

    public static <T> T getClassFieldValue(Class<?> target, String fieldName) throws IllegalAccessException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(fieldName), "Field name must not be null or empty", new Object[0]);
        Field field = ReflectionUtils.findField(target, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(MessageFormat.format("Field \"{0}\" not found", fieldName));
        }
        return ReflectionUtils.getFieldValue(null, field);
    }

    public static <T> T getFieldValue(Object target, Field field) throws IllegalAccessException {
        Contract.checkArgument(field != null, "Field must not be null", new Object[0]);
        ReflectionUtils.ensureAccessible(field);
        return (T)field.get(target);
    }

    public static <T> T getInstanceFieldValue(Object target, String fieldName) throws IllegalAccessException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(fieldName), "Field name must not be null or empty", new Object[0]);
        Field field = ReflectionUtils.findField(target.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException(MessageFormat.format("Field \"{0}\" not found", fieldName));
        }
        return ReflectionUtils.getFieldValue(target, field);
    }

    public static void incrementClassFieldValue(Class<?> target, String fieldName) throws IllegalAccessException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(fieldName), "Field name must not be null or empty", new Object[0]);
        Field field = ReflectionUtils.findField(target.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException(MessageFormat.format("Field \"{0}\" not found", fieldName));
        }
        ReflectionUtils.incrementFieldValue(null, field);
    }

    public static void incrementFieldValue(Object target, Field field) throws IllegalAccessException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(field != null, "Field must not be null", new Object[0]);
        Class<?> fieldType = field.getType();
        if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
            Integer value = (Integer)ReflectionUtils.getFieldValue(target, field);
            value = Math.incrementExact(value);
            ReflectionUtils.setFieldValue(target, field, value);
            return;
        }
        if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
            Long value = (Long)ReflectionUtils.getFieldValue(target, field);
            value = Math.incrementExact(value);
            ReflectionUtils.setFieldValue(target, field, value);
            return;
        }
        throw new IllegalArgumentException(MessageFormat.format("Field \"{0}\" is not of incrementable type", field.getName()));
    }

    public static void incrementInstanceFieldValue(Object target, String fieldName) throws IllegalAccessException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(fieldName), "Field name must not be null or empty", new Object[0]);
        Field field = ReflectionUtils.findField(target.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException(MessageFormat.format("Field \"{0}\" not found", fieldName));
        }
        ReflectionUtils.incrementFieldValue(target, field);
    }

    public static <T> T invokeClassMethod(Class<?> target, String methodName, Class<?>[] parameterTypes, Object[] arguments) throws IllegalAccessException, InvocationTargetException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(methodName), "Method name must not be null or empty", new Object[0]);
        Method method = ReflectionUtils.findMethod(target, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException(MessageFormat.format("Method \"{0}\" not found", methodName));
        }
        return ReflectionUtils.invokeMethod(null, method, arguments);
    }

    public static <T> T invokeInstanceMethod(Object target, String methodName, Class<?>[] parameterTypes, Object[] arguments) throws IllegalAccessException, InvocationTargetException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(methodName), "Method name must not be null or empty", new Object[0]);
        Method method = ReflectionUtils.findMethod(target.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException(MessageFormat.format("Method \"{0}\" not found", methodName));
        }
        return ReflectionUtils.invokeMethod(target, method, arguments);
    }

    public static <T> T invokeMethod(Object target, Method method, Object[] arguments) throws IllegalAccessException, InvocationTargetException {
        Contract.checkArgument(method != null, "Method must not be null", new Object[0]);
        return (T)method.invoke(target, arguments);
    }

    public static void setClassFieldValue(Class<?> target, String fieldName, Object value) throws IllegalAccessException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(fieldName), "Field name must not be null or empty", new Object[0]);
        Field field = ReflectionUtils.findField(target, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(MessageFormat.format("Field \"{0}\" not found", fieldName));
        }
        ReflectionUtils.setFieldValue(null, field, value);
    }

    public static void setFieldValue(Object target, Field field, Object value) throws IllegalAccessException {
        Contract.checkArgument(field != null, "Field must not be null", new Object[0]);
        ReflectionUtils.ensureAccessible(field);
        ReflectionUtils.ensureModifiable(field);
        field.set(target, value);
    }

    public static void setInstanceFieldValue(Object target, String fieldName, Object value) throws IllegalAccessException {
        Contract.checkArgument(target != null, "Target object must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(fieldName), "Field name must not be null or empty", new Object[0]);
        Field field = ReflectionUtils.findField(target.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException(MessageFormat.format("Field \"{0}\" not found", fieldName));
        }
        ReflectionUtils.setFieldValue(target, field, value);
    }

    private static void ensureAccessible(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    private static void ensureModifiable(Field field) throws IllegalAccessException {
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

