/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.io.charset;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.sellcom.core.internal.io.charset.ISO_8859_10;
import org.sellcom.core.internal.io.charset.ISO_8859_14;
import org.sellcom.core.internal.io.charset.ISO_8859_16;
import org.sellcom.core.internal.io.charset.Utf8BomCharset;

public class MoreCharsetsProvider
extends CharsetProvider {
    private static final Map<String, Charset> PROVIDED_CHARSETS;

    @Override
    public Iterator<Charset> charsets() {
        return PROVIDED_CHARSETS.values().iterator();
    }

    @Override
    public Charset charsetForName(String charsetName) {
        return PROVIDED_CHARSETS.getOrDefault(charsetName, null);
    }

    private static void registerCharset(NavigableMap<String, Charset> charsets, Charset charset) {
        charsets.put(charset.name(), charset);
        charset.aliases().forEach(alias -> charsets.put((String)alias, charset));
    }

    static {
        TreeMap<String, Charset> providedCharsets = new TreeMap<String, Charset>(String.CASE_INSENSITIVE_ORDER);
        MoreCharsetsProvider.registerCharset(providedCharsets, new ISO_8859_10());
        MoreCharsetsProvider.registerCharset(providedCharsets, new ISO_8859_14());
        MoreCharsetsProvider.registerCharset(providedCharsets, new ISO_8859_16());
        MoreCharsetsProvider.registerCharset(providedCharsets, new Utf8BomCharset());
        PROVIDED_CHARSETS = Collections.unmodifiableNavigableMap(providedCharsets);
    }
}

