/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.io.encoding;

import java.io.ByteArrayOutputStream;
import org.sellcom.core.Contract;
import org.sellcom.core.io.encoding.BinaryCodingException;
import org.sellcom.core.io.encoding.BinaryDecoder;
import org.sellcom.core.io.encoding.BinaryEncoder;
import org.sellcom.core.io.encoding.BinaryEncoding;
import org.sellcom.core.math.MoreMath;

public final class Base16Encoding
extends BinaryEncoding {
    @Override
    public BinaryDecoder newDecoder() {
        return new Decoder();
    }

    @Override
    public BinaryEncoder newEncoder() {
        return new Encoder();
    }

    private static class Encoder
    extends BinaryEncoder {
        private Encoder() {
        }

        @Override
        public String encodeToString(byte[] input) {
            Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
            StringBuilder builder = new StringBuilder();
            for (byte currentByte : input) {
                builder.append(Character.toUpperCase(Character.forDigit(currentByte >> 4 & 0xF, 16)));
                builder.append(Character.toUpperCase(Character.forDigit(currentByte >> 0 & 0xF, 16)));
            }
            return builder.toString();
        }
    }

    private static class Decoder
    extends BinaryDecoder {
        private Decoder() {
        }

        @Override
        public byte[] decode(String input) {
            Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
            Contract.check(MoreMath.isEven(input.length()), BinaryCodingException.class, "Odd number of bytes: {0}", input.length());
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int j = input.length();
            for (int i = 0; i < j; ++i) {
                byte loNibble;
                byte hiNibble = (byte)Character.digit(input.charAt(i), 16);
                if (hiNibble == -1) {
                    throw new BinaryCodingException(String.format("Illegal byte at position %d: 0x%02X", i, (int)input.charAt(i)));
                }
                if ((loNibble = (byte)Character.digit(input.charAt(++i), 16)) == -1) {
                    throw new BinaryCodingException(String.format("Illegal byte at position %d: 0x%02X", i, (int)input.charAt(i)));
                }
                stream.write(hiNibble << 4 | loNibble);
            }
            return stream.toByteArray();
        }
    }
}

