/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.sellcom.core.Contract;
import org.sellcom.core.collection.Iterables;

public class MoreFiles {
    private MoreFiles() {
    }

    public static void deleteDirectoryContents(Path path) throws IOException {
        Contract.checkArgument(path != null, "Path must not be null", new Object[0]);
        Contract.checkArgument(Files.isDirectory(path, new LinkOption[0]), "Path must be an existing directory", new Object[0]);
        Files.walkFileTree(path, new ContentsDeletingVisitor(path));
    }

    public static void deleteRecursively(Path path) throws IOException {
        Contract.checkArgument(path != null, "Path must not be null", new Object[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            MoreFiles.deleteDirectoryContents(path);
        }
        Files.delete(path);
    }

    public static Path ensureDirectory(Path path) throws IOException {
        Contract.checkArgument(path != null, "Path must not be null", new Object[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return Files.createDirectories(path, new FileAttribute[0]);
        }
        throw new FileAlreadyExistsException(path.toString());
    }

    public static Path ensureParentDirectory(Path path) throws IOException {
        Contract.checkArgument(path != null, "Path must not be null", new Object[0]);
        Path parentDirectory = path.getParent();
        if (parentDirectory != null) {
            MoreFiles.ensureDirectory(parentDirectory);
        }
        return parentDirectory;
    }

    public static boolean isEmptyDirectory(Path path) throws IOException {
        Contract.checkArgument(path != null, "Path must not be null", new Object[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                boolean bl = Iterables.isNullOrEmpty(directoryStream);
                return bl;
            }
        }
        return false;
    }

    private static class ContentsDeletingVisitor
    extends SimpleFileVisitor<Path> {
        private final Path rootDirectory;

        private ContentsDeletingVisitor(Path rootDirectory) {
            this.rootDirectory = rootDirectory;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException exception) throws IOException {
            if (exception != null) {
                throw exception;
            }
            if (!directory.equals(this.rootDirectory)) {
                Files.delete(directory);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exception) throws IOException {
            if (exception != null) {
                throw exception;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

