/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.sellcom.core.Contract;

public class MorePaths {
    private MorePaths() {
    }

    public static Path canonicalize(Path path) {
        Contract.checkArgument(path != null, "Path must not be null", new Object[0]);
        return path.toAbsolutePath().normalize();
    }

    public static String getFileExtension(Path path) {
        String fileName = MorePaths.getFileName(path);
        int lastDot = fileName.lastIndexOf(46);
        return lastDot > 0 ? fileName.substring(lastDot + 1) : "";
    }

    public static String getFileName(Path path) {
        Contract.checkArgument(path != null, "Path must not be null", new Object[0]);
        Path fileName = path.getFileName();
        return fileName != null ? fileName.toString() : "";
    }

    public static String getFileNameWithoutExtension(Path path) {
        String fileName = MorePaths.getFileName(path);
        int lastDot = fileName.lastIndexOf(46);
        return lastDot > 0 ? fileName.substring(0, lastDot) : fileName;
    }

    public static Path getJavaHomeDirectory() {
        return Paths.get(System.getProperty("java.home"), new String[0]);
    }

    public static Path getUserHomeDirectory() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    public static Path getWorkingDirectory() {
        return Paths.get("", new String[0]);
    }
}

