/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io.charset;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sellcom.core.io.charset.MoreCharsets;

class LocaleToCharset {
    private LocaleToCharset() {
    }

    static List<Charset> getSupportedCharsets(Locale locale) {
        switch (locale.getLanguage()) {
            case "af": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252);
            }
            case "ar": {
                LocaleToCharset.ensureScript(locale, "Arab");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_6, MoreCharsets.WINDOWS_1256);
            }
            case "ast": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "az": {
                LocaleToCharset.ensureScript(locale, "Cyrl", "Latn");
                if (Objects.equals(locale.getScript(), "Cyrl")) {
                    return LocaleToCharset.customCharsets(new Charset[0]);
                }
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "be": {
                LocaleToCharset.ensureScript(locale, "Cyrl");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_5, MoreCharsets.WINDOWS_1251);
            }
            case "bg": {
                LocaleToCharset.ensureScript(locale, "Cyrl");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_5, MoreCharsets.KOI8_R, MoreCharsets.KOI8_U, MoreCharsets.WINDOWS_31J, MoreCharsets.WINDOWS_949, MoreCharsets.WINDOWS_1251);
            }
            case "br": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "bs": {
                LocaleToCharset.ensureScript(locale, "Cyrl", "Latn");
                if (Objects.equals(locale.getScript(), "Cyrl")) {
                    return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_5, MoreCharsets.WINDOWS_1251);
                }
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250);
            }
            case "ca": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "co": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "crh": {
                LocaleToCharset.ensureScript(locale, "Cyrl", "Latn");
                if (Objects.equals(locale.getScript(), "Cyrl")) {
                    return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_5, MoreCharsets.KOI8_R, MoreCharsets.KOI8_U, MoreCharsets.WINDOWS_31J, MoreCharsets.WINDOWS_949, MoreCharsets.WINDOWS_1251);
                }
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.WINDOWS_1254);
            }
            case "cs": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.WINDOWS_1250);
            }
            case "cy": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_14);
            }
            case "da": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1257, MoreCharsets.WINDOWS_1258);
            }
            case "de": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1257, MoreCharsets.WINDOWS_1258);
            }
            case "dsb": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.WINDOWS_1250);
            }
            case "el": {
                LocaleToCharset.ensureScript(locale, "Grek");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_7, MoreCharsets.WINDOWS_1253);
            }
            case "en": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.asciiCompatibleCharsets();
            }
            case "eo": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_3);
            }
            case "es": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "et": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1257);
            }
            case "eu": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "ext": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "fa": {
                LocaleToCharset.ensureScript(locale, "Arab");
                return LocaleToCharset.customCharsets(MoreCharsets.WINDOWS_1256);
            }
            case "fi": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1257);
            }
            case "fo": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252);
            }
            case "fr": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "fur": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "fy": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "ga": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "gd": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "gl": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "gv": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "haw": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.asciiCompatibleCharsets();
            }
            case "hi": {
                LocaleToCharset.ensureScript(locale, "Deva");
                return LocaleToCharset.customCharsets(MoreCharsets.ISCII91);
            }
            case "hr": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250);
            }
            case "hsb": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.WINDOWS_1250);
            }
            case "hu": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250);
            }
            case "hy": {
                LocaleToCharset.ensureScript(locale, "Armn");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "in": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1257, MoreCharsets.WINDOWS_1258);
            }
            case "is": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252);
            }
            case "it": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "iu": {
                LocaleToCharset.ensureScript(locale, "Cans", "Latn");
                switch (locale.getScript()) {
                    case "Cans": {
                        return LocaleToCharset.customCharsets(new Charset[0]);
                    }
                }
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_949, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1257);
            }
            case "iw": {
                LocaleToCharset.ensureScript(locale, "Hebr");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_8, MoreCharsets.WINDOWS_1255);
            }
            case "ja": {
                LocaleToCharset.ensureScript(locale, "Jpan");
                return LocaleToCharset.customCharsets(MoreCharsets.EUC_JP, MoreCharsets.ISO_2022_JP, MoreCharsets.SHIFT_JIS, MoreCharsets.WINDOWS_31J);
            }
            case "ji": {
                LocaleToCharset.ensureScript(locale, "Hebr");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "ka": {
                LocaleToCharset.ensureScript(locale, "Geok", "Geor");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "kk": {
                LocaleToCharset.ensureScript(locale, "Cyrl", "Latn");
                if (Objects.equals(locale.getScript(), "Latn")) {
                    return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.WINDOWS_1254);
                }
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "kl": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1257, MoreCharsets.WINDOWS_1258);
            }
            case "ko": {
                LocaleToCharset.ensureScript(locale, "Kore");
                return LocaleToCharset.customCharsets(MoreCharsets.EUC_KR, MoreCharsets.ISO_2022_KR, MoreCharsets.WINDOWS_949);
            }
            case "krl": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1257);
            }
            case "ku": {
                LocaleToCharset.ensureScript(locale, "Arab", "Latn");
                switch (locale.getScript()) {
                    case "Arab": {
                        return LocaleToCharset.customCharsets(new Charset[0]);
                    }
                    case "Latn": {
                        return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.WINDOWS_1254);
                    }
                }
                switch (locale.getCountry()) {
                    case "AM": {
                        return LocaleToCharset.customCharsets(new Charset[0]);
                    }
                    case "IQ": {
                        return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.WINDOWS_1254);
                    }
                    case "IR": {
                        return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.WINDOWS_1254);
                    }
                    case "SY": {
                        return LocaleToCharset.customCharsets(new Charset[0]);
                    }
                    case "TR": {
                        return LocaleToCharset.customCharsets(new Charset[0]);
                    }
                }
                break;
            }
            case "kw": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.asciiCompatibleCharsets();
            }
            case "ky": {
                LocaleToCharset.ensureScript(locale, "Cyrl");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "la": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.asciiCompatibleCharsets();
            }
            case "lb": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "li": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "lij": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.ISO_8859_9, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "llt": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "lt": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.WINDOWS_1257);
            }
            case "lv": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.WINDOWS_1257);
            }
            case "me": {
                LocaleToCharset.ensureScript(locale, "Cyrl", "Latn");
                if (Objects.equals(locale.getScript(), "Cyrl")) {
                    return LocaleToCharset.customCharsets(new Charset[0]);
                }
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250);
            }
            case "mk": {
                LocaleToCharset.ensureScript(locale, "Cyrl");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_5, MoreCharsets.WINDOWS_1251);
            }
            case "mn": {
                LocaleToCharset.ensureScript(locale, "Cyrl");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "ms": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.asciiCompatibleCharsets();
            }
            case "mt": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_3);
            }
            case "nb": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "nds": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1257, MoreCharsets.WINDOWS_1258);
            }
            case "nl": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "nn": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "oc": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "pl": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1257);
            }
            case "pms": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "ps": {
                LocaleToCharset.ensureScript(locale, "Arab");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "pt": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "rm": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "ro": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_16);
            }
            case "ru": {
                LocaleToCharset.ensureScript(locale, "Cyrl");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_5, MoreCharsets.KOI8_R, MoreCharsets.KOI8_U, MoreCharsets.WINDOWS_31J, MoreCharsets.WINDOWS_949, MoreCharsets.WINDOWS_1251);
            }
            case "rue": {
                LocaleToCharset.ensureScript(locale, "Cyrl");
                return LocaleToCharset.customCharsets(MoreCharsets.KOI8_U, MoreCharsets.WINDOWS_1251);
            }
            case "sc": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "scn": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.asciiCompatibleCharsets();
            }
            case "sco": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "se": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_10);
            }
            case "sk": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.WINDOWS_1250);
            }
            case "sl": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1257);
            }
            case "sq": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1258);
            }
            case "sr": {
                LocaleToCharset.ensureScript(locale, "Cyrl", "Latn");
                if (Objects.equals(locale.getScript(), "Latn")) {
                    return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1250);
                }
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_5, MoreCharsets.WINDOWS_1251);
            }
            case "sv": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1257, MoreCharsets.WINDOWS_1258);
            }
            case "sw": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.asciiCompatibleCharsets();
            }
            case "ta": {
                LocaleToCharset.ensureScript(locale, "Taml");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "tg": {
                LocaleToCharset.ensureScript(locale, "Cyrl");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "th": {
                LocaleToCharset.ensureScript(locale, "Thai");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_11, MoreCharsets.TIS_620, MoreCharsets.WINDOWS_874);
            }
            case "tk": {
                LocaleToCharset.ensureScript(locale, "Cyrl", "Latn");
                if (Objects.equals(locale.getScript(), "Cyrl")) {
                    return LocaleToCharset.customCharsets(new Charset[0]);
                }
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_2, MoreCharsets.WINDOWS_1250);
            }
            case "tl": {
                LocaleToCharset.ensureScript(locale, "Tglg");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "tn": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1254);
            }
            case "tr": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_9, MoreCharsets.WINDOWS_1254);
            }
            case "tt": {
                LocaleToCharset.ensureScript(locale, "Cyrl");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "uk": {
                LocaleToCharset.ensureScript(locale, "Cyrl");
                return LocaleToCharset.customCharsets(MoreCharsets.KOI8_U, MoreCharsets.WINDOWS_1251);
            }
            case "ur": {
                LocaleToCharset.ensureScript(locale, "Arab");
                return LocaleToCharset.customCharsets(MoreCharsets.WINDOWS_1256);
            }
            case "uz": {
                LocaleToCharset.ensureScript(locale, "Cyrl", "Latn");
                if (Objects.equals(locale.getScript(), "Cyrl")) {
                    return LocaleToCharset.customCharsets(new Charset[0]);
                }
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "vec": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "vi": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(MoreCharsets.WINDOWS_1258);
            }
            case "wa": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.customCharsets(new Charset[0]);
            }
            case "xh": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.asciiCompatibleCharsets();
            }
            case "zh": {
                LocaleToCharset.ensureScript(locale, "Hans", "Hant");
                switch (locale.getScript()) {
                    case "Hans": {
                        return LocaleToCharset.simplifiedChineseCharsets();
                    }
                    case "Hant": {
                        return LocaleToCharset.traditionalChineseCharsets();
                    }
                }
                switch (locale.getCountry()) {
                    case "CN": {
                        return LocaleToCharset.simplifiedChineseCharsets();
                    }
                    case "HK": {
                        return LocaleToCharset.traditionalChineseCharsets();
                    }
                    case "MO": {
                        return LocaleToCharset.traditionalChineseCharsets();
                    }
                    case "SG": {
                        return LocaleToCharset.simplifiedChineseCharsets();
                    }
                    case "TW": {
                        return LocaleToCharset.traditionalChineseCharsets();
                    }
                }
                break;
            }
            case "zu": {
                LocaleToCharset.ensureScript(locale, "Latn");
                return LocaleToCharset.asciiCompatibleCharsets();
            }
        }
        return LocaleToCharset.customCharsets(new Charset[0]);
    }

    private static List<Charset> asciiCompatibleCharsets() {
        return LocaleToCharset.customCharsets(MoreCharsets.BIG5, MoreCharsets.BIG5_HKSCS, MoreCharsets.EUC_JP, MoreCharsets.EUC_KR, MoreCharsets.GB2312, MoreCharsets.GB18030, MoreCharsets.GBK, MoreCharsets.ISCII91, MoreCharsets.ISO_2022_CN, MoreCharsets.ISO_2022_JP, MoreCharsets.ISO_2022_KR, StandardCharsets.ISO_8859_1, MoreCharsets.ISO_8859_2, MoreCharsets.ISO_8859_3, MoreCharsets.ISO_8859_4, MoreCharsets.ISO_8859_5, MoreCharsets.ISO_8859_6, MoreCharsets.ISO_8859_7, MoreCharsets.ISO_8859_8, MoreCharsets.ISO_8859_9, MoreCharsets.ISO_8859_10, MoreCharsets.ISO_8859_11, MoreCharsets.ISO_8859_13, MoreCharsets.ISO_8859_14, MoreCharsets.ISO_8859_15, MoreCharsets.ISO_8859_16, MoreCharsets.KOI8_R, MoreCharsets.KOI8_U, MoreCharsets.SHIFT_JIS, MoreCharsets.TIS_620, MoreCharsets.WINDOWS_31J, MoreCharsets.WINDOWS_874, MoreCharsets.WINDOWS_949, MoreCharsets.WINDOWS_1250, MoreCharsets.WINDOWS_1251, MoreCharsets.WINDOWS_1252, MoreCharsets.WINDOWS_1253, MoreCharsets.WINDOWS_1254, MoreCharsets.WINDOWS_1255, MoreCharsets.WINDOWS_1256, MoreCharsets.WINDOWS_1257, MoreCharsets.WINDOWS_1258);
    }

    private static List<Charset> customCharsets(Charset ... additionalCharsets) {
        Stream<Charset> charsetStream = additionalCharsets == null ? LocaleToCharset.univeralCharsets() : Stream.concat(LocaleToCharset.univeralCharsets(), Arrays.stream(additionalCharsets));
        return charsetStream.collect(Collectors.toList());
    }

    private static void ensureScript(Locale locale, String ... scripts) {
        String script = locale.getScript();
        if (Objects.equals(script, "")) {
            return;
        }
        if (Arrays.binarySearch(scripts, script) != -1) {
            return;
        }
        throw new IllegalArgumentException(String.format("Unsupported locale: %s", locale));
    }

    private static List<Charset> simplifiedChineseCharsets() {
        return LocaleToCharset.customCharsets(MoreCharsets.GB2312, MoreCharsets.GB18030, MoreCharsets.GBK, MoreCharsets.ISO_2022_CN);
    }

    private static List<Charset> traditionalChineseCharsets() {
        return LocaleToCharset.customCharsets(MoreCharsets.BIG5, MoreCharsets.BIG5_HKSCS, MoreCharsets.ISO_2022_CN);
    }

    private static Stream<Charset> univeralCharsets() {
        return Stream.of(StandardCharsets.UTF_8, MoreCharsets.UTF_8BOM, StandardCharsets.UTF_16, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE, MoreCharsets.UTF_32, MoreCharsets.UTF_32BE, MoreCharsets.UTF_32LE);
    }
}

