/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io.type;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;

public class ContentTypes {
    private static final Pattern extractCharsetPattern = Pattern.compile("(?<=;charset=)(?<charset>[^;]+)");
    private static final Pattern replaceCharsetPattern = Pattern.compile("(;charset=[^;]+)");

    private ContentTypes() {
    }

    public static Charset getCharset(String contentType) {
        Contract.checkArgument(!Strings.isNullOrEmpty(contentType), "Content type must not be null or empty", new Object[0]);
        Matcher matcher = extractCharsetPattern.matcher(contentType);
        if (matcher.find()) {
            String charsetName = Strings.toUpperCase(matcher.group("charset").trim());
            return Charset.forName(charsetName);
        }
        return StandardCharsets.UTF_8;
    }

    public static String setCharset(String contentType, Charset charset) {
        Contract.checkArgument(!Strings.isNullOrEmpty(contentType), "Content type must not be null or empty", new Object[0]);
        Contract.checkArgument(charset != null, "Charset must not be null", new Object[0]);
        Matcher matcher = replaceCharsetPattern.matcher(contentType);
        StringBuilder builder = new StringBuilder();
        builder.append(matcher.replaceAll(""));
        builder.append(";charset=");
        builder.append(Strings.toLowerCase(charset.name()));
        return builder.toString();
    }
}

