/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.io.encoding.BinaryDecoder;
import org.sellcom.core.io.encoding.BinaryEncoder;
import org.sellcom.core.io.encoding.StandardBinaryEncodings;
import org.sellcom.core.util.MoreArrays;

public class Uuids {
    private static final BinaryDecoder BASE58_DECODER = StandardBinaryEncodings.createBase58FlickrDecoder();
    private static final BinaryEncoder BASE58_ENCODER = StandardBinaryEncodings.createBase58FlickrEncoder();

    private Uuids() {
    }

    public static String format8x4(UUID uuid) {
        Contract.checkArgument(uuid != null, "UUID must not be null", new Object[0]);
        StringBuilder builder = new StringBuilder(uuid.toString());
        builder.insert(4, "-");
        builder.insert(29, "-");
        builder.insert(34, "-");
        return Strings.toUpperCase(builder.toString());
    }

    public static String formatBase58(UUID uuid) {
        Contract.checkArgument(uuid != null, "UUID must not be null", new Object[0]);
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        buffer.flip();
        return new String(BASE58_ENCODER.encode(buffer).array(), StandardCharsets.UTF_8);
    }

    public static UUID fromBytes(byte[] bytes) {
        Contract.checkArgument(!MoreArrays.isNullOrEmpty(bytes), "Bytes must not be null or empty", new Object[0]);
        return UUID.nameUUIDFromBytes(bytes);
    }

    public static UUID fromString(String string) {
        Contract.checkArgument(!Strings.isNullOrEmpty(string), "String must not be null or empty", new Object[0]);
        return UUID.nameUUIDFromBytes(string.getBytes(StandardCharsets.UTF_8));
    }

    public static UUID parse8x4(String string) {
        Contract.checkArgument(!Strings.isNullOrEmpty(string), "String must not be null or empty", new Object[0]);
        StringBuilder builder = new StringBuilder(string);
        builder.deleteCharAt(34);
        builder.deleteCharAt(29);
        builder.deleteCharAt(4);
        return UUID.fromString(builder.toString());
    }

    public static UUID parseBase58(String string) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        ByteBuffer buffer = ByteBuffer.wrap(BASE58_DECODER.decode(string));
        return new UUID(buffer.getLong(), buffer.getLong());
    }
}

