/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingLongSupplier
extends LongSupplier {
    default public LongSupplier fallbackTo(LongSupplier fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public LongSupplier fallbackTo(LongSupplier fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback supplier must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsLongThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.getAsLong();
            }
        };
    }

    @Override
    default public long getAsLong() {
        try {
            return this.getAsLongThrowing();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public long getAsLongThrowing() throws Exception;

    default public LongSupplier orReturn(long value) {
        return this.orReturn(value, null);
    }

    default public LongSupplier orReturn(long value, Consumer<Exception> exceptionConsumer) {
        return () -> {
            try {
                return this.getAsLongThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingLongSupplier orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsLongThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingLongSupplier orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsLongThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingLongSupplier orTryWith(ThrowingLongSupplier other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingLongSupplier orTryWith(ThrowingLongSupplier other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other supplier must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsLongThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.getAsLongThrowing();
            }
        };
    }
}

