/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingRunnable
extends Runnable {
    default public Runnable fallbackTo(Runnable fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public Runnable fallbackTo(Runnable fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback runnable must not be null", new Object[0]);
        return () -> {
            try {
                this.runThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                fallback.run();
            }
        };
    }

    default public Runnable orDoNothing() {
        return this.orDoNothing(null);
    }

    default public Runnable orDoNothing(Consumer<Exception> exceptionConsumer) {
        return () -> {
            block2: {
                try {
                    this.runThrowing();
                }
                catch (Exception e) {
                    if (exceptionConsumer == null) break block2;
                    exceptionConsumer.accept(e);
                }
            }
        };
    }

    default public ThrowingRunnable orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                this.runThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingRunnable orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                this.runThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingRunnable orTryWith(ThrowingRunnable other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingRunnable orTryWith(ThrowingRunnable other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other runnable must not be null", new Object[0]);
        return () -> {
            try {
                this.runThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                other.runThrowing();
            }
        };
    }

    @Override
    default public void run() {
        try {
            this.runThrowing();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public void runThrowing() throws Exception;
}

