/*
 * Decompiled with CFR 0.152.
 */
package org.semispace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.semispace.Holder;
import org.semispace.HolderElement;

public class HolderContainer {
    private Map<String, HolderElement> heads = null;
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static HolderContainer instance = null;

    private HolderContainer() {
        this.heads = new HashMap<String, HolderElement>();
    }

    public static synchronized HolderContainer retrieveContainer() {
        if (instance == null) {
            instance = new HolderContainer();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HolderElement next(String className) {
        this.rwl.writeLock().lock();
        try {
            HolderElement holderElement = this.heads.get(className);
            return holderElement;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Holder removeHolderById(long id, String className) {
        Holder toReturn = null;
        this.rwl.writeLock().lock();
        try {
            HolderElement head = this.heads.get(className);
            if (head == null) {
                Holder holder = null;
                return holder;
            }
            if (head.getHolder().getId() == id) {
                toReturn = head.getHolder();
                if ((head = head.next()) == null) {
                    this.heads.remove(className);
                } else {
                    this.heads.put(className, head);
                }
            } else {
                toReturn = head.removeHolderById(id);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Holder findById(long id, String className) {
        this.rwl.readLock().lock();
        try {
            for (HolderElement n = this.heads.get(className); n != null; n = n.next()) {
                Holder found = n.findById(id);
                if (found == null) continue;
                Holder holder = n.getHolder();
                return holder;
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHolder(Holder add) {
        this.rwl.writeLock().lock();
        try {
            if (add == null) {
                throw new RuntimeException("Illegal to add null");
            }
            if (add.getClassName() == null) {
                throw new RuntimeException("Need classname in holder with contents " + add.getXml());
            }
            HolderElement head = this.heads.get(add.getClassName());
            if (head == null) {
                head = new HolderElement(add);
                this.heads.put(add.getClassName(), head);
            } else {
                head.addHolder(add);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.rwl.readLock().lock();
        try {
            if (this.heads == null) {
                int n = 0;
                return n;
            }
            int size = 0;
            Iterator<HolderElement> i$ = this.heads.values().iterator();
            while (i$.hasNext()) {
                HolderElement head;
                for (HolderElement c = head = i$.next(); c != null; c = c.next()) {
                    ++size;
                }
            }
            int n = size;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] retrieveGroupNames() {
        this.rwl.readLock().lock();
        String[] result = null;
        try {
            result = this.heads.keySet().toArray(new String[0]);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return result;
    }

    public Holder readHolderWithId(long id) {
        String[] cnames;
        for (String lookup : cnames = this.retrieveClassNames()) {
            for (HolderElement next = this.next(lookup); next != null; next = next.next()) {
                Holder elem = next.getHolder();
                if (id != elem.getId()) continue;
                return elem;
            }
        }
        return null;
    }

    public Long[] findAllHolderIds() {
        String[] cnames;
        ArrayList<Long> allIds = new ArrayList<Long>();
        for (String lookup : cnames = this.retrieveClassNames()) {
            for (HolderElement next = this.next(lookup); next != null; next = next.next()) {
                Holder elem = next.getHolder();
                allIds.add(elem.getId());
            }
        }
        return allIds.toArray(new Long[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] retrieveClassNames() {
        this.rwl.readLock().lock();
        String[] cnames = null;
        try {
            cnames = this.heads.keySet().toArray(new String[0]);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return cnames;
    }
}

