/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.admin;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.semispace.SemiSpace;
import org.semispace.SemiSpaceInterface;
import org.semispace.admin.SemiSpaceAdmin;

public class PeriodicHarvest {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private SemiSpaceAdmin semiSpaceAdmin;
    private ScheduledFuture<?> handle;

    public PeriodicHarvest(SemiSpaceAdmin semiSpaceAdmin) {
        this.semiSpaceAdmin = semiSpaceAdmin;
    }

    public void startReaper() {
        if (this.handle != null) {
            this.cancelReaper();
        }
        Runnable harvester = new Runnable(){

            public void run() {
                SemiSpaceInterface space = PeriodicHarvest.this.semiSpaceAdmin.getSpace();
                if (PeriodicHarvest.this.semiSpaceAdmin.isMaster() && space instanceof SemiSpace) {
                    ((SemiSpace)space).harvest();
                }
            }
        };
        this.handle = this.scheduler.scheduleAtFixedRate(harvester, 120L, 60L, TimeUnit.SECONDS);
    }

    public void cancelReaper() {
        if (this.handle != null) {
            this.handle.cancel(true);
        }
        this.handle = null;
    }

    public boolean isCancelled() {
        if (this.handle != null) {
            return this.handle.isCancelled();
        }
        return true;
    }
}

