/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.actor;

import com.thoughtworks.xstream.XStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.semispace.SemiEventListener;
import org.semispace.SemiSpaceInterface;
import org.semispace.actor.Actor;
import org.semispace.actor.ActorManifest;
import org.semispace.actor.ActorMessage;
import org.semispace.actor.SwingActor;
import org.semispace.event.SemiAvailabilityEvent;
import org.semispace.event.SemiEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActorNotification
implements SemiEventListener {
    private static final Logger log = LoggerFactory.getLogger(ActorNotification.class);
    private Actor actor;
    private SemiSpaceInterface space;
    private Object template;
    private ExecutorService pool = null;
    private boolean toTake;

    public ActorNotification(Actor actor, SemiSpaceInterface space, Object template, boolean toTake) {
        this.actor = actor;
        this.space = space;
        this.template = template;
        this.toTake = toTake;
        if (!actor.getClass().isAnnotationPresent(SwingActor.class)) {
            this.pool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
    }

    @Override
    public void notify(final SemiEvent theEvent) {
        if (theEvent instanceof SemiAvailabilityEvent) {
            Runnable receive = new Runnable(){

                @Override
                public void run() {
                    Object element = null;
                    element = ActorNotification.this.toTake ? ActorNotification.this.space.takeIfExists(ActorNotification.this.template) : ActorNotification.this.space.readIfExists(ActorNotification.this.template);
                    ActorMessage payload = null;
                    if (element instanceof ActorMessage) {
                        payload = (ActorMessage)element;
                    } else if (element != null) {
                        payload = new ActorMessage();
                        payload.setPayload(element);
                        ActorManifest manifest = new ActorManifest(theEvent.getId());
                        manifest = ActorNotification.this.toTake ? ActorNotification.this.space.take(manifest, 1000L) : ActorNotification.this.space.read(manifest, 1000L);
                        if (manifest != null) {
                            payload.setOriginatorId(manifest.getOriginatorId());
                        }
                    } else {
                        log.debug("Probably having competing listeners, and this listener was not quick enough to take the object.");
                        return;
                    }
                    ActorMessage msg = payload;
                    if (msg.getOriginatorId() == null) {
                        throw new RuntimeException("Originator was not found for message with address " + msg.getAddress() + " and payload " + msg.getPayload().getClass().getName());
                    }
                    try {
                        ActorNotification.this.actor.receive(msg);
                    }
                    catch (Exception e) {
                        XStream xStream = new XStream();
                        log.error("Got exception with template:\n" + xStream.toXML(ActorNotification.this.template) + "\n... and incoming actor message ...\n" + xStream.toXML((Object)msg), (Throwable)e);
                    }
                }
            };
            if (this.pool == null) {
                SwingUtilities.invokeLater(receive);
            } else {
                this.pool.submit(receive);
            }
        }
    }
}

