/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.admin;

import java.util.ArrayList;
import org.semispace.SemiSpace;
import org.semispace.SemiSpaceInterface;
import org.semispace.admin.IdentifyAdminQuery;
import org.semispace.admin.SemiSpaceAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledSemiSpaceHarvester
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ScheduledSemiSpaceHarvester.class);
    private SemiSpaceAdmin semiSpaceAdmin;
    private long lastCheck;
    private static final long MIN_CHECK_WAIT_MS = 120000L;

    public ScheduledSemiSpaceHarvester(SemiSpaceAdmin semiSpaceAdmin) {
        this.semiSpaceAdmin = semiSpaceAdmin;
        this.lastCheck = System.currentTimeMillis();
    }

    @Override
    public void run() {
        SemiSpaceInterface space = this.semiSpaceAdmin.getSpace();
        if (this.semiSpaceAdmin.isMaster()) {
            if (space instanceof SemiSpace) {
                ((SemiSpace)space).harvest();
            }
        } else {
            this.ensurePresenceOfAdmin();
        }
    }

    private void ensurePresenceOfAdmin() {
        if (this.semiSpaceAdmin.isMaster()) {
            return;
        }
        if (this.lastCheck + 120000L > System.currentTimeMillis()) {
            return;
        }
        this.lastCheck = System.currentTimeMillis();
        IdentifyAdminQuery admin = this.semiSpaceAdmin.populateListOfAllSpaces(new ArrayList<IdentifyAdminQuery>());
        if (admin == null) {
            log.info("Assuming admin responsibility in current space, as admin instance was not found");
            this.semiSpaceAdmin.assumeAdminResponsibility(true);
        }
    }
}

