/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.admin;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.semispace.EventDistributor;
import org.semispace.Holder;
import org.semispace.NameValueQuery;
import org.semispace.SemiSpace;
import org.semispace.SemiSpaceInterface;
import org.semispace.admin.DaemonDelegateFactory;
import org.semispace.admin.IdentifyAdminQuery;
import org.semispace.admin.InternalQuery;
import org.semispace.admin.PeriodicHarvest;
import org.semispace.admin.SemiSpaceAdminInterface;
import org.semispace.admin.TimeAnswer;
import org.semispace.admin.TimeQuery;
import org.semispace.event.SemiAvailabilityEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemiSpaceAdmin
implements SemiSpaceAdminInterface {
    private static final Logger log = LoggerFactory.getLogger(SemiSpaceAdmin.class);
    private boolean master;
    private SemiSpaceInterface space;
    private boolean beenInitialized;
    private long clockSkew;
    private int spaceId;
    private ExecutorService pool;
    private Thread shutDownHook;
    private PeriodicHarvest periodicHarvest;

    public SemiSpaceAdmin(SemiSpaceInterface terraSpace) {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true));
        tpe.setThreadFactory(new DaemonDelegateFactory(tpe.getThreadFactory()));
        tpe.allowCoreThreadTimeOut(true);
        this.pool = tpe;
        this.space = terraSpace;
        this.beenInitialized = false;
        this.clockSkew = 0L;
        this.spaceId = 0;
        this.master = false;
        this.periodicHarvest = new PeriodicHarvest(this);
    }

    protected int getSpaceId() {
        return this.spaceId;
    }

    protected SemiSpaceInterface getSpace() {
        return this.space;
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.pool;
    }

    @Override
    public boolean hasBeenInitialized() {
        return this.beenInitialized;
    }

    @Override
    public boolean isMaster() {
        return this.master;
    }

    @Override
    public long calculateTime() {
        return System.currentTimeMillis() - this.clockSkew;
    }

    @Override
    public void performInitialization() {
        long last;
        if (this.beenInitialized) {
            log.warn("Initialization called more than once.");
            return;
        }
        this.beenInitialized = true;
        Runnable hook = new Runnable(){

            @Override
            public void run() {
                log.info("Shutdown hook shutting down semispace.");
                SemiSpaceAdmin.this.shutdownAndAwaitTermination();
            }
        };
        this.shutDownHook = new Thread(hook);
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        long current = 86400000L;
        int count = 0;
        do {
            ++count;
            last = current;
        } while ((current = this.fireUpConnection()) < last);
        log.info("Needed " + count + " iterations in order to find the best time, which was " + current + " ms.");
        this.spaceId = this.figureOutSpaceId();
        log.info("Space id was found to be " + this.spaceId);
        this.queryForMasterTime();
        this.periodicHarvest = new PeriodicHarvest(this);
        this.periodicHarvest.startReaper();
    }

    private int figureOutSpaceId() {
        ArrayList<IdentifyAdminQuery> admins = new ArrayList<IdentifyAdminQuery>();
        IdentifyAdminQuery masterFound = this.populateListOfAllSpaces(admins);
        Collections.sort(admins, new Comparator<IdentifyAdminQuery>(){

            @Override
            public int compare(IdentifyAdminQuery a1, IdentifyAdminQuery a2) {
                if (a1.id == null) {
                    return 1;
                }
                if (a2.id == null) {
                    return -1;
                }
                return a2.id - a1.id;
            }
        });
        int foundId = 1;
        if (!admins.isEmpty()) {
            IdentifyAdminQuery admin = (IdentifyAdminQuery)admins.get(0);
            if (admin.id != null) {
                foundId = admin.id + 1;
            }
        }
        if (masterFound == null) {
            log.info("I am master, as no other master was identified.");
            this.assumeAdminResponsibility(!admins.isEmpty());
        }
        return foundId;
    }

    protected void assumeAdminResponsibility(boolean sendAdminInfoAboutSystemTime) {
        this.master = true;
        if (sendAdminInfoAboutSystemTime) {
            log.info("Informing other masters of system time.");
            TimeAnswer ta = new TimeAnswer();
            ta.masterId = this.getSpaceId();
            ta.timeFromMaster = System.currentTimeMillis();
            this.space.write(ta, 1000L);
        }
    }

    protected IdentifyAdminQuery populateListOfAllSpaces(List<IdentifyAdminQuery> admins) {
        IdentifyAdminQuery identifyAdmin = new IdentifyAdminQuery();
        identifyAdmin.hasAnswered = Boolean.FALSE;
        this.space.write(identifyAdmin, 86400000L);
        IdentifyAdminQuery iaq = new IdentifyAdminQuery();
        iaq.hasAnswered = Boolean.TRUE;
        IdentifyAdminQuery masterFound = null;
        IdentifyAdminQuery answer = null;
        long waitFor = 750L;
        do {
            answer = this.space.take(iaq, waitFor);
            waitFor = 250L;
            if (answer == null) continue;
            admins.add(answer);
            if (!Boolean.TRUE.equals(answer.amIAdmin)) continue;
            if (masterFound != null) {
                log.error("More than one admin found, both " + masterFound.id + " and " + answer.id);
            }
            masterFound = answer;
        } while (answer != null);
        while (this.space.takeIfExists(new IdentifyAdminQuery()) != null) {
        }
        return masterFound;
    }

    private long fireUpConnection() {
        long bench = System.currentTimeMillis();
        NameValueQuery nvq = new NameValueQuery();
        nvq.name = "Internal admin query";
        nvq.value = "Dummy-value in order to be (quite) unique [" + bench + "]";
        this.space.write(nvq, 86400000L);
        nvq = this.space.take(nvq, 1000L);
        if (nvq == null) {
            throw new AssertionError((Object)"Unable to retrieve query which is designed to kickstart space.");
        }
        long timed = System.currentTimeMillis() - bench;
        return timed;
    }

    private void queryForMasterTime() {
        TimeQuery tq = new TimeQuery();
        tq.isFinished = Boolean.FALSE;
        this.space.write(tq, 86400000L);
        this.space.read(new TimeAnswer(), 2500L);
        this.space.takeIfExists(tq);
    }

    private void notifyAboutInternalQuery(InternalQuery incoming) {
        if (incoming instanceof TimeQuery) {
            this.answerTimeQuery((TimeQuery)incoming);
        } else if (incoming instanceof IdentifyAdminQuery) {
            this.answerIdentityQuery((IdentifyAdminQuery)incoming);
        } else if (incoming instanceof TimeAnswer) {
            this.treatIncomingTimeAnswer((TimeAnswer)incoming);
        } else {
            log.warn("Unknown internal query");
        }
    }

    private void treatIncomingTimeAnswer(TimeAnswer incoming) {
        if (this.isMaster()) {
            if (incoming.masterId != this.getSpaceId()) {
                String adminfo = "Got more than one space that perceives it is admin space: " + incoming.masterId + " and myself: " + this.getSpaceId();
                if (incoming.masterId < this.getSpaceId()) {
                    this.master = false;
                    adminfo = adminfo + ". Removing this space as master.";
                } else {
                    adminfo = adminfo + ". Keeping this space as master.";
                }
                log.warn(adminfo);
            } else {
                this.clockSkew = 0L;
            }
        }
        if (!this.isMaster()) {
            long systime = System.currentTimeMillis();
            this.clockSkew = systime - incoming.timeFromMaster;
            log.info("Master has  [" + new Date(incoming.timeFromMaster) + "]" + ", whereas I have [" + new Date(systime) + "]. This gives a skew of " + this.clockSkew + ".");
        }
    }

    private void answerIdentityQuery(IdentifyAdminQuery identify) {
        if (this.spaceId < 1) {
            return;
        }
        if (identify.hasAnswered != null && identify.hasAnswered.booleanValue()) {
            return;
        }
        IdentifyAdminQuery answer = new IdentifyAdminQuery();
        answer.amIAdmin = this.master;
        answer.hasAnswered = Boolean.TRUE;
        answer.id = this.spaceId;
        log.debug("Giving identity answer for space " + this.spaceId + ", which is" + (this.master ? "" : " NOT") + " master.");
        this.space.write(answer, 86400000L);
    }

    private void answerTimeQuery(TimeQuery tq) {
        if (this.isMaster() && !tq.isFinished.booleanValue()) {
            TimeAnswer answer = new TimeAnswer();
            answer.timeFromMaster = System.currentTimeMillis();
            answer.masterId = this.getSpaceId();
            this.space.write(answer, 1000L);
            log.info("Giving answer about time (which was found to be " + answer.timeFromMaster + ", which is " + new Date(answer.timeFromMaster) + ")");
        }
    }

    @Override
    public void notifyAboutEvent(EventDistributor event) {
        Holder holder;
        if (event.getEvent() instanceof SemiAvailabilityEvent && InternalQuery.class.getName().equals(event.getHolderClassName()) && this.space instanceof SemiSpace && (holder = ((SemiSpace)this.space).readHolderById(event.getEvent().getId())) != null) {
            this.notifyAboutInternalQuery((InternalQuery)new XStream().fromXML(holder.getXml()));
        }
    }

    protected void shutdownAndAwaitTermination() {
        if (this.pool.isShutdown() && this.periodicHarvest.isCancelled()) {
            return;
        }
        this.periodicHarvest.cancelReaper();
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
                if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    log.warn("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ignored) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void removeShutDownHook() {
        this.periodicHarvest.cancelReaper();
        if (this.shutDownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
        }
    }
}

