/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.space.tutorial;

import org.semispace.SemiEventListener;
import org.semispace.SemiEventRegistration;
import org.semispace.SemiSpace;
import org.semispace.SemiSpaceInterface;
import org.semispace.event.SemiAvailabilityEvent;
import org.semispace.event.SemiEvent;
import org.semispace.space.tutorial.Element;

public class NotifyFromSpace
implements SemiEventListener {
    public static void main(String[] args) {
        System.out.println("Awaiting notification of all objects of type Element");
        System.out.println("Is to be stopped with CTRL-C");
        new NotifyFromSpace().startUpAndWait();
    }

    public void notify(SemiEvent theEvent) {
        if (theEvent instanceof SemiAvailabilityEvent) {
            System.out.println("Incoming element which concurs with template has arrived.");
            Element element = (Element)SemiSpace.retrieveSpace().takeIfExists((Object)new Element());
            if (element == null) {
                System.out.println("Could not take element that was flagged as available");
            } else {
                System.out.println("Read element from space: " + element.getName() + "=" + element.getValue());
            }
        }
    }

    private void startUpAndWait() {
        try {
            SemiSpaceInterface space = SemiSpace.retrieveSpace();
            SemiEventRegistration eventRegistration = space.notify((Object)new Element(), (SemiEventListener)this, 3600000L);
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            eventRegistration.getLease().cancel();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

