/*
 * Decompiled with CFR 0.152.
 */
package org.semispace;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.semispace.Holder;
import org.semispace.HolderElement;
import org.semispace.exception.SemiSpaceObjectException;
import org.semispace.exception.SemiSpaceUsageException;

public class HolderContainer {
    private AtomicLong idseq = new AtomicLong();
    private Map<String, HolderElement> heads = null;
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static HolderContainer instance = new HolderContainer();

    private HolderContainer() {
        this.heads = new ConcurrentHashMap<String, HolderElement>();
    }

    public static synchronized HolderContainer retrieveContainer() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HolderElement next(String className) {
        this.rwl.writeLock().lock();
        try {
            HolderElement holderElement = this.heads.get(className);
            return holderElement;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Holder removeHolderById(long id, String className) {
        Holder toReturn = null;
        this.rwl.writeLock().lock();
        try {
            HolderElement head = this.heads.get(className);
            if (head == null) {
                Holder holder = null;
                return holder;
            }
            toReturn = head.removeHolderById(id);
            if (this.idseq.longValue() % 5000L == 0L && head.size() < 1) {
                this.removeEmptyHeads();
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        return toReturn;
    }

    private void removeEmptyHeads() {
        ArrayList<String> toPurge = new ArrayList<String>();
        for (String name : this.heads.keySet()) {
            HolderElement head = this.heads.get(name);
            if (head.isWaiting() || head.size() >= 1) continue;
            toPurge.add(name);
        }
        for (String name : toPurge) {
            this.heads.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Holder findById(long id, String className) {
        this.rwl.readLock().lock();
        try {
            HolderElement n = this.heads.get(className);
            if (n == null) {
                Holder holder = null;
                return holder;
            }
            Holder holder = n.findById(id);
            return holder;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHolder(Holder add) {
        this.rwl.writeLock().lock();
        try {
            if (add == null) {
                throw new SemiSpaceUsageException("Illegal to add null");
            }
            if (add.getClassName() == null) {
                throw new SemiSpaceObjectException("Need classname in holder with contents " + add.getXml());
            }
            HolderElement head = this.heads.get(add.getClassName());
            if (head == null) {
                head = HolderElement.createNewCollection(add);
                this.heads.put(add.getClassName(), head);
            } else {
                head.addHolder(add);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.rwl.readLock().lock();
        try {
            if (this.heads == null) {
                int n = 0;
                return n;
            }
            int size = 0;
            for (HolderElement head : this.heads.values()) {
                size += head.size();
            }
            int n = size;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] retrieveGroupNames() {
        this.rwl.readLock().lock();
        String[] result = null;
        try {
            result = this.heads.keySet().toArray(new String[0]);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return result;
    }

    public Holder readHolderWithId(long id) {
        String[] cnames;
        for (String lookup : cnames = this.retrieveClassNames()) {
            HolderElement next = this.next(lookup);
            Holder toReturn = next.findById(id);
            if (toReturn == null) continue;
            return toReturn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long[] findAllHolderIds() {
        String[] cnames;
        ArrayList<Long> allIds = new ArrayList<Long>();
        for (String lookup : cnames = this.retrieveClassNames()) {
            HolderElement next = this.next(lookup);
            this.rwl.readLock().lock();
            try {
                for (Holder elem : next.toArray()) {
                    allIds.add(elem.getId());
                }
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
        return allIds.toArray(new Long[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] retrieveClassNames() {
        this.rwl.readLock().lock();
        String[] cnames = null;
        try {
            cnames = this.heads.keySet().toArray(new String[0]);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return cnames;
    }

    public Holder addHolder(String xml, long liveUntil, String entryClassName, Map<String, String> searchMap) {
        long holderId = this.incrementReturnNextId();
        Holder holder = new Holder(xml, liveUntil, entryClassName, holderId, searchMap);
        this.addHolder(holder);
        return holder;
    }

    public long incrementReturnNextId() {
        return this.idseq.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitHolder(String className, long timeout) {
        HolderElement e = null;
        this.rwl.writeLock().lock();
        try {
            e = this.heads.get(className);
            if (e == null) {
                e = new HolderElement();
                this.heads.put(className, e);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        e.waitHolder(timeout);
    }
}

