/*
 * Decompiled with CFR 0.152.
 */
package org.semispace;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.semispace.Holder;
import org.semispace.exception.SemiSpaceInternalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolderElement
implements Iterable<Holder> {
    private static final Logger log = LoggerFactory.getLogger(HolderElement.class);
    private Map<Long, Holder> elements = new ConcurrentHashMap<Long, Holder>();
    private boolean waiting;

    public synchronized int size() {
        return this.elements.size();
    }

    public static synchronized HolderElement createNewCollection(Holder holder) {
        HolderElement hc = new HolderElement();
        hc.addHolder(holder);
        return hc;
    }

    public synchronized Holder removeHolderById(long id) {
        Holder found = this.elements.remove(id);
        return found;
    }

    public synchronized Holder findById(long id) {
        Holder found = this.elements.get(id);
        return found;
    }

    public synchronized void addHolder(Holder add) {
        Holder old = this.elements.put(add.getId(), add);
        if (old != null) {
            throw new SemiSpaceInternalException("Unexpected duplication id IDs. Found twice: " + old.getId());
        }
        this.notifyAll();
    }

    public synchronized Holder[] toArray() {
        return this.elements.values().toArray(new Holder[0]);
    }

    @Override
    public synchronized Iterator<Holder> iterator() {
        return this.elements.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitHolder(long timeout) {
        if (this.elements.isEmpty()) {
            try {
                this.waiting = true;
                this.wait(timeout);
            }
            catch (InterruptedException ex) {
                log.warn("InterruptedException ignored: " + ex);
            }
            finally {
                this.waiting = false;
            }
        }
    }

    public boolean isWaiting() {
        return this.waiting;
    }
}

