/*
 * Decompiled with CFR 0.152.
 */
package org.semispace;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.semispace.SemiEventListener;
import org.semispace.event.SemiAvailabilityEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemiBlockingListener
implements SemiEventListener<SemiAvailabilityEvent> {
    private static final Logger log = LoggerFactory.getLogger(SemiBlockingListener.class);
    private transient CountDownLatch latch;
    private transient Boolean beenNotified;

    public SemiBlockingListener() {
        this.reset();
    }

    public final void reset() {
        this.beenNotified = Boolean.FALSE;
    }

    @Override
    public void notify(SemiAvailabilityEvent theEvent) {
        this.beenNotified = Boolean.TRUE;
        this.unblock();
    }

    private void unblock() {
        if (this.latch != null) {
            this.latch.countDown();
        }
    }

    public void block(long msToWait) {
        this.latch = new CountDownLatch(1);
        try {
            if (!this.beenNotified.booleanValue()) {
                this.latch.await(msToWait * 1000L, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException ignore) {
            log.error("Got interrupted exception (which unblocks await)");
        }
    }

    public boolean hasBeenNotified() {
        return this.beenNotified;
    }
}

