/*
 * Decompiled with CFR 0.152.
 */
package org.semispace;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.semispace.DistributedEvent;
import org.semispace.ElementLease;
import org.semispace.EventDistributor;
import org.semispace.Holder;
import org.semispace.HolderContainer;
import org.semispace.HolderElement;
import org.semispace.ListenerHolder;
import org.semispace.ListenerLease;
import org.semispace.SemiEventListener;
import org.semispace.SemiEventRegistration;
import org.semispace.SemiLease;
import org.semispace.SemiSpaceInterface;
import org.semispace.SemiSpaceStatistics;
import org.semispace.admin.InternalQuery;
import org.semispace.admin.SemiSpaceAdmin;
import org.semispace.admin.SemiSpaceAdminInterface;
import org.semispace.event.SemiAvailabilityEvent;
import org.semispace.event.SemiEvent;
import org.semispace.event.SemiExpirationEvent;
import org.semispace.event.SemiRenewalEvent;
import org.semispace.event.SemiTakenEvent;
import org.semispace.exception.SemiSpaceInternalException;
import org.semispace.exception.SemiSpaceObjectException;
import org.semispace.exception.SemiSpaceUsageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemiSpace
implements SemiSpaceInterface {
    private static final String ADMIN_GROUP_IS_FLAGGED = "adminGroupIsFlagged";
    private static final Logger log = LoggerFactory.getLogger(SemiSpace.class);
    public static final long ONE_DAY = 86400000L;
    private static SemiSpace instance = null;
    private long listenerId = 0L;
    private HolderContainer elements = null;
    private transient Map<Long, ListenerHolder> listeners;
    private transient SemiSpaceAdminInterface admin;
    private transient Map<String, Field[]> classFieldMap = new WeakHashMap<String, Field[]>();
    private SemiSpaceStatistics statistics;
    private transient XStream xStream;
    private EventDistributor eventDistributor = EventDistributor.getInstance();
    private Set<String> checkedClassSet = new HashSet<String>();

    private SemiSpace() {
        this.elements = HolderContainer.retrieveContainer();
        this.listeners = new ConcurrentHashMap<Long, ListenerHolder>();
        this.statistics = new SemiSpaceStatistics();
        this.xStream = new XStream();
        this.setAdmin(new SemiSpaceAdmin(this));
    }

    public static synchronized SemiSpaceInterface retrieveSpace() {
        if (instance == null) {
            instance = new SemiSpace();
        }
        if (!SemiSpace.instance.admin.hasBeenInitialized()) {
            SemiSpace.instance.admin.performInitialization();
        }
        return instance;
    }

    @Override
    public SemiEventRegistration notify(Object tmpl, SemiEventListener listener, long duration) {
        if (tmpl == null) {
            log.warn("Not registering notification on null object.");
            return null;
        }
        Map<String, String> searchProps = this.retrievePropertiesFromObject(tmpl);
        SemiEventRegistration registration = this.notify(searchProps, listener, duration);
        return registration;
    }

    public SemiEventRegistration notify(Map<String, String> searchProps, SemiEventListener listener, long duration) {
        if (listener == null) {
            log.warn("Not allowing listener to be null.");
            return null;
        }
        if (searchProps == null) {
            log.warn("Not allowing search props to be null");
            return null;
        }
        if (duration <= 0L) {
            log.warn("Not registering notification when duration is <= 0. It was " + duration);
            return null;
        }
        ListenerHolder holder = null;
        ++this.listenerId;
        holder = new ListenerHolder(this.listenerId, listener, duration + this.admin.calculateTime(), searchProps);
        if (this.listeners.put(holder.getId(), holder) != null) {
            throw new SemiSpaceInternalException("Internal assertion error. Listener map already had element with id " + holder.getId());
        }
        this.statistics.increaseNumberOfListeners();
        ListenerLease lease = new ListenerLease(holder, this);
        SemiEventRegistration eventRegistration = new SemiEventRegistration(holder.getId(), lease);
        return eventRegistration;
    }

    protected void notifyListeners(DistributedEvent distributedEvent) {
        ArrayList<SemiEventListener> toNotify = new ArrayList<SemiEventListener>();
        ListenerHolder[] listenerArray = this.listeners.values().toArray(new ListenerHolder[0]);
        Arrays.sort(listenerArray, new ShortestTtlComparator());
        for (ListenerHolder listener : listenerArray) {
            if (listener.getLiveUntil() < this.admin.calculateTime()) {
                this.cancelListener(listener);
                continue;
            }
            if (!this.hasSubSet(distributedEvent.getEntrySet(), listener.getSearchMap())) continue;
            SemiEventListener notifyMe = listener.getListener();
            toNotify.add(notifyMe);
        }
        SemiEvent event = distributedEvent.getEvent();
        for (SemiEventListener notify : toNotify) {
            try {
                notify.notify(event);
            }
            catch (ClassCastException ignored) {}
        }
        this.admin.notifyAboutEvent(distributedEvent);
    }

    @Override
    public SemiLease write(Object entry, long leaseTimeMs) {
        if (entry == null) {
            return null;
        }
        WrappedInternalWriter write = new WrappedInternalWriter(entry, leaseTimeMs);
        Future<?> future = this.admin.getThreadPool().submit(write);
        Exception exception = null;
        try {
            future.get();
        }
        catch (CancellationException e) {
            log.error("Got exception", (Throwable)e);
            exception = e;
        }
        catch (InterruptedException e) {
            log.error("Got exception", (Throwable)e);
            exception = e;
        }
        catch (ExecutionException e) {
            log.error("Got exception", (Throwable)e);
            exception = e;
        }
        if (write.getException() != null || exception != null) {
            String error = " Writing object (of type " + entry.getClass().getName() + ") to space gave exception. XML version: " + this.objectToXml(entry);
            if (write.getException() != null) {
                exception = write.getException();
            }
            throw new SemiSpaceObjectException(error, exception);
        }
        return write.getLease();
    }

    private SemiLease writeInternally(Object entry, long leaseTimeMs) {
        String entryClassName = entry.getClass().getName();
        if (entry instanceof InternalQuery) {
            entryClassName = InternalQuery.class.getName();
        }
        String xml = this.objectToXml(entry);
        Map<String, String> searchMap = this.retrievePropertiesFromObject(entry);
        return this.writeToElements(entryClassName, leaseTimeMs, xml, searchMap);
    }

    public SemiLease writeToElements(String entryClassName, long leaseTimeMs, String xml, Map<String, String> searchMap) {
        Holder holder = null;
        if (!this.checkedClassSet.contains(entryClassName)) {
            this.checkedClassSet.add(entryClassName);
            if (xml.contains("<outer-class>")) {
                log.warn("It seems that " + entryClassName + " is an inner class. This is DISCOURAGED as it WILL serialize the outer " + "class as well. If you did not intend this, note that what you store MAY be significantly larger than you " + "expected. This warning is printed once for each class type.");
            }
        }
        holder = this.elements.addHolder(xml, this.admin.calculateTime() + leaseTimeMs, entryClassName, searchMap);
        ElementLease lease = new ElementLease(holder, this);
        this.statistics.increaseWrite();
        SemiAvailabilityEvent semiEvent = new SemiAvailabilityEvent(holder.getId());
        this.distributeEvent(new DistributedEvent(holder.getClassName(), semiEvent, holder.getSearchMap()));
        return lease;
    }

    private void distributeEvent(final DistributedEvent distributedEvent) {
        Runnable distRunnable = new Runnable(){

            @Override
            public void run() {
                SemiSpace.this.eventDistributor.distributeEvent(distributedEvent);
            }
        };
        if (!this.getAdmin().getThreadPool().isShutdown()) {
            try {
                this.admin.getThreadPool().execute(distRunnable);
            }
            catch (RejectedExecutionException e) {
                log.error("Could not schedule notification", (Throwable)e);
            }
        } else {
            log.warn("Thread pool is shut down, not relaying event");
        }
    }

    @Override
    public <T> T read(T tmpl, long timeout) {
        String found = null;
        if (tmpl != null) {
            found = this.findOrWaitLeaseForTemplate(this.getPropertiesForObject(tmpl), timeout, false);
        }
        return (T)this.xmlToObject(found);
    }

    public String findOrWaitLeaseForTemplate(Map<String, String> templateSet, long timeout, boolean isToTakeTheLease) {
        long until = this.admin.calculateTime() + timeout;
        long systime = this.admin.calculateTime();
        String className = templateSet.get("class");
        if (templateSet.get(ADMIN_GROUP_IS_FLAGGED) != null) {
            className = InternalQuery.class.getName();
        }
        String found = null;
        long subtract = 0L;
        do {
            long duration = timeout - subtract;
            if (isToTakeTheLease) {
                this.statistics.increaseBlockingTake();
            } else {
                this.statistics.increaseBlockingRead();
            }
            found = this.findLeaseForTemplate(templateSet, isToTakeTheLease);
            if (found == null && duration > 0L) {
                this.elements.waitHolder(className, duration);
            }
            if (isToTakeTheLease) {
                this.statistics.decreaseBlockingTake();
            } else {
                this.statistics.decreaseBlockingRead();
            }
            long now = this.getAdmin().calculateTime();
            subtract += now - systime;
            systime = now;
        } while (found == null && systime < until);
        return found;
    }

    @Override
    public <T> T readIfExists(T tmpl) {
        return this.read(tmpl, 0L);
    }

    private String findLeaseForTemplate(Map<String, String> templateSet, boolean isToTakeTheLease) {
        HolderElement next;
        Holder found = null;
        ArrayList<Holder> toEvict = new ArrayList<Holder>();
        if (templateSet.get("class") == null) {
            throw new SemiSpaceObjectException("Did not expect classname to be null");
        }
        String className = templateSet.get("class");
        if (templateSet.get(ADMIN_GROUP_IS_FLAGGED) != null) {
            className = InternalQuery.class.getName();
        }
        if ((next = this.elements.next(className)) != null) {
            Iterator<Holder> it = next.iterator();
            while (found == null && it.hasNext()) {
                Holder elem = it.next();
                if (elem.getLiveUntil() < this.admin.calculateTime()) {
                    toEvict.add(elem);
                    elem = null;
                }
                if (elem == null || !this.hasSubSet(elem.getSearchMap().entrySet(), templateSet)) continue;
                found = elem;
            }
        }
        for (Holder evict : toEvict) {
            if (this.cancelElement(evict.getId(), false, evict.getClassName())) continue;
            log.debug("Element with id " + evict.getId() + " should exist in most cases. This time, it is probably missing as it belongs to a timed out query.");
        }
        boolean needToRetake = false;
        if (found != null && isToTakeTheLease && !this.cancelElement(found.getId(), isToTakeTheLease, found.getClassName())) {
            log.info("Element with id " + found.getId() + " ceased to exist during take. " + "This is not an error; Just an indication of a busy space. ");
            found = null;
            needToRetake = true;
        }
        if (needToRetake) {
            return this.findLeaseForTemplate(templateSet, isToTakeTheLease);
        }
        if (found != null) {
            if (isToTakeTheLease) {
                this.statistics.increaseTake();
            } else {
                this.statistics.increaseRead();
            }
        } else if (isToTakeTheLease) {
            this.statistics.increaseMissedTake();
        } else {
            this.statistics.increaseMissedRead();
        }
        if (found != null) {
            return found.getXml();
        }
        return null;
    }

    public Holder readHolderById(long hId) {
        Holder result = null;
        result = this.elements.readHolderWithId(hId);
        return result;
    }

    private boolean hasSubSet(Set<Map.Entry<String, String>> containerEntrySet, Map<String, String> templateSubSet) {
        if (templateSubSet == null) {
            throw new SemiSpaceUsageException("Did not expect template sub set to be null");
        }
        Set<Map.Entry<String, String>> templateEntrySet = templateSubSet.entrySet();
        return containerEntrySet.containsAll(templateEntrySet);
    }

    @Override
    public <T> T take(T tmpl, long timeout) {
        String found = null;
        if (tmpl != null) {
            found = this.findOrWaitLeaseForTemplate(this.getPropertiesForObject(tmpl), timeout, true);
        }
        return (T)this.xmlToObject(found);
    }

    @Override
    public <T> T takeIfExists(T tmpl) {
        return this.take(tmpl, 0L);
    }

    private String objectToXml(Object obj) {
        StringWriter writer = new StringWriter();
        this.xStream.marshal(obj, (HierarchicalStreamWriter)new CompactWriter((Writer)writer));
        return writer.toString();
    }

    private Object xmlToObject(String xml) {
        if (xml == null || "".equals(xml)) {
            return null;
        }
        Object result = null;
        try {
            result = this.xStream.fromXML(xml);
        }
        catch (Exception e) {
            log.error("Got exception unmarshalling. Not throwing the exception up, but rather returning null. This is as the cause may be a change in the object which is sent over. The XML was read as\n" + xml, (Throwable)e);
        }
        return result;
    }

    public Object processTemplate(Object template) {
        PreprocessedTemplate toReturn = null;
        if (template != null) {
            toReturn = new PreprocessedTemplate(template, this.retrievePropertiesFromObject(template));
        }
        return toReturn;
    }

    private Map<String, String> getPropertiesForObject(Object object) {
        if (object instanceof PreprocessedTemplate) {
            return ((PreprocessedTemplate)object).getCachedSet();
        }
        return this.retrievePropertiesFromObject(object);
    }

    protected Map<String, String> retrievePropertiesFromObject(Object examine) {
        Map<String, String> map = this.fillMapWithPublicFields(examine);
        this.addGettersToMap(examine, map);
        if (examine instanceof InternalQuery) {
            map.put(ADMIN_GROUP_IS_FLAGGED, "true");
        }
        String className = map.remove("class");
        map.put("class", className.substring("class ".length()));
        return map;
    }

    private void addGettersToMap(Object examine, Map<String, String> map) {
        HashSet<String> getters = new HashSet<String>();
        Method[] methods = examine.getClass().getMethods();
        HashMap<String, Method> keyedMethod = new HashMap<String, Method>();
        HashMap<String, String> keyedMethodName = new HashMap<String, String>();
        for (Method method : methods) {
            String name = method.getName();
            int parameterLength = method.getTypeParameters().length;
            if (parameterLength != 0 || !name.startsWith("get")) continue;
            String normalized = name.substring(3, 4).toLowerCase() + name.substring(4);
            getters.add(normalized);
            keyedMethod.put(name, method);
            keyedMethodName.put(normalized, name);
        }
        for (String name : getters) {
            try {
                Object value = ((Method)keyedMethod.get(keyedMethodName.get(name))).invoke(examine, null);
                if (value == null) continue;
                map.put(name, "" + value);
            }
            catch (IllegalAccessException e) {
                log.error("Could not access method g" + name + ". Got (masked exception) " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.error("Could not access method g" + name + ". Got (masked exception) " + e.getMessage());
            }
        }
    }

    private Map<String, String> fillMapWithPublicFields(Object examine) {
        Field[] fields = this.classFieldMap.get(examine.getClass().getName());
        if (fields == null) {
            fields = examine.getClass().getFields();
            this.classFieldMap.put(examine.getClass().getName(), fields);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field field : fields) {
            try {
                String name = field.getName();
                Object value = field.get(examine);
                if (value == null) continue;
                map.put(name, "" + value);
            }
            catch (IllegalAccessException e) {
                log.warn("Introspection gave exception - which is not re-thrown.", (Throwable)e);
            }
        }
        return map;
    }

    public void setAdmin(SemiSpaceAdminInterface admin) {
        this.admin = admin;
    }

    public SemiSpaceAdminInterface getAdmin() {
        return this.admin;
    }

    public void harvest() {
        String[] groups;
        for (ListenerHolder listener : this.listeners.values()) {
            if (listener.getLiveUntil() >= this.admin.calculateTime()) continue;
            this.cancelListener(listener);
        }
        ArrayList<Holder> beforeEvict = new ArrayList<Holder>();
        for (String group : groups = this.elements.retrieveGroupNames()) {
            int evictSize = beforeEvict.size();
            HolderElement hc = this.elements.next(group);
            for (Holder elem : hc) {
                if (elem.getLiveUntil() >= this.admin.calculateTime()) continue;
                beforeEvict.add(elem);
            }
            long afterSize = beforeEvict.size() - evictSize;
            if (afterSize <= 0L) continue;
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Holder evict : beforeEvict) {
                ids.add(evict.getId());
            }
            String moreInfo = "";
            if (ids.size() < 30) {
                Collections.sort(ids);
                moreInfo = "Ids: " + ids;
            }
            log.debug("Testing group " + group + " gave " + afterSize + " element(s) to evict. " + moreInfo);
        }
        for (Holder evict : beforeEvict) {
            this.cancelElement(evict.getId(), false, evict.getClassName());
        }
    }

    public int numberOfSpaceElements() {
        int size = this.elements.size();
        return size;
    }

    public int numberOfBlockingRead() {
        return this.statistics.getBlockingRead();
    }

    public int numberOfBlockingTake() {
        return this.statistics.getBlockingTake();
    }

    public int numberOfMissedRead() {
        return this.statistics.getMissedRead();
    }

    public int numberOfMissedTake() {
        return this.statistics.getMissedTake();
    }

    public int numberOfNumberOfListeners() {
        return this.statistics.getNumberOfListeners();
    }

    public int numberOfRead() {
        return this.statistics.getRead();
    }

    public int numberOfTake() {
        return this.statistics.getTake();
    }

    public int numberOfWrite() {
        return this.statistics.getWrite();
    }

    protected SemiSpaceStatistics getStatistics() {
        SemiSpaceStatistics stats = (SemiSpaceStatistics)this.xmlToObject(this.objectToXml(this.statistics));
        return stats;
    }

    protected boolean cancelListener(ListenerHolder holder) {
        boolean success = false;
        ListenerHolder listener = this.listeners.remove(holder.getId());
        if (listener != null) {
            this.statistics.decreaseNumberOfListeners();
            success = true;
        }
        return success;
    }

    protected boolean renewListener(ListenerHolder holder, long duration) {
        boolean success = false;
        ListenerHolder listener = this.listeners.get(holder.getId());
        if (listener != null) {
            listener.setLiveUntil(duration + this.admin.calculateTime());
            success = this.listeners.get(holder.getId()) != null;
        }
        return success;
    }

    protected boolean cancelElement(Long id, boolean isTake, String className) {
        boolean success = false;
        Holder elem = this.elements.removeHolderById(id, className);
        if (elem != null) {
            if (elem.getId() != id.longValue()) {
                throw new SemiSpaceInternalException("Sanity problem. Removed " + id + " and got back element with id " + elem.getId());
            }
            success = true;
            SemiEvent semiEvent = null;
            semiEvent = isTake ? new SemiTakenEvent(elem.getId()) : new SemiExpirationEvent(elem.getId());
            this.distributeEvent(new DistributedEvent(elem.getClassName(), semiEvent, elem.getSearchMap()));
        }
        return success;
    }

    protected boolean renewElement(Holder holder, long duration) {
        boolean success = false;
        Holder elem = this.elements.findById(holder.getId(), holder.getClassName());
        if (elem != null) {
            elem.setLiveUntil(duration + this.admin.calculateTime());
            success = true;
            this.distributeEvent(new DistributedEvent(elem.getClassName(), new SemiRenewalEvent(elem.getId(), elem.getLiveUntil()), elem.getSearchMap()));
        }
        return success;
    }

    public Long[] findAllHolderIds() {
        Long[] result = null;
        result = this.elements.findAllHolderIds();
        return result;
    }

    public XStream getXStream() {
        return this.xStream;
    }

    private static class ShortestTtlComparator
    implements Comparator<ListenerHolder>,
    Serializable {
        private ShortestTtlComparator() {
        }

        @Override
        public int compare(ListenerHolder o1, ListenerHolder o2) {
            if (o1 == null || o2 == null) {
                throw new SemiSpaceUsageException("Did not expect any null values for listenerHolder.");
            }
            return (int)(o1.getLiveUntil() - o2.getLiveUntil());
        }
    }

    protected class WrappedInternalWriter
    implements Runnable {
        private Object entry;
        private long leaseTimeMs;
        private Exception exception;
        private SemiLease lease;

        public Exception getException() {
            return this.exception;
        }

        public SemiLease getLease() {
            return this.lease;
        }

        protected WrappedInternalWriter(Object entry, long leaseTimeMs) {
            this.entry = entry;
            this.leaseTimeMs = leaseTimeMs;
        }

        @Override
        public void run() {
            try {
                this.lease = SemiSpace.this.writeInternally(this.entry, this.leaseTimeMs);
            }
            catch (Exception e) {
                log.debug("Got exception writing object.", (Throwable)e);
                this.exception = e;
            }
        }
    }

    private static class PreprocessedTemplate {
        private Object object;
        private Map<String, String> cachedSet;

        public PreprocessedTemplate(Object object, Map<String, String> cachedSet) {
            this.object = object;
            this.cachedSet = cachedSet;
        }

        public Map<String, String> getCachedSet() {
            return this.cachedSet;
        }

        public void setCachedSet(Map<String, String> cachedSet) {
            this.cachedSet = cachedSet;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }
}

