/*
 * Decompiled with CFR 0.152.
 */
package org.semispace.admin;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.semispace.admin.DaemonDelegateFactory;
import org.semispace.admin.ScheduledSemiSpaceHarvester;
import org.semispace.admin.SemiSpaceAdmin;

public class PeriodicHarvest {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private SemiSpaceAdmin semiSpaceAdmin;
    private ScheduledFuture<?> handle;

    public PeriodicHarvest(SemiSpaceAdmin semiSpaceAdmin) {
        this.semiSpaceAdmin = semiSpaceAdmin;
        if (this.scheduler instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor stpe = (ScheduledThreadPoolExecutor)this.scheduler;
            stpe.setThreadFactory(new DaemonDelegateFactory(stpe.getThreadFactory()));
        }
    }

    public void startReaper() {
        if (this.handle != null) {
            this.cancelReaper();
        }
        ScheduledSemiSpaceHarvester harvester = new ScheduledSemiSpaceHarvester(this.semiSpaceAdmin);
        this.handle = this.scheduler.scheduleAtFixedRate(harvester, 60L, 15L, TimeUnit.SECONDS);
    }

    public void cancelReaper() {
        if (this.handle != null) {
            this.handle.cancel(true);
        }
        this.handle = null;
    }

    public boolean isCancelled() {
        if (this.handle != null) {
            return this.handle.isCancelled();
        }
        return true;
    }
}

