/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.Fail;
import org.fest.assertions.StringAssert;
import org.sonar.java.AnalyzerMessage;

public abstract class CheckVerifier {
    public static final String ISSUE_MARKER = "Noncompliant";
    public static final Map<String, IssueAttribute> ATTRIBUTE_MAP = ImmutableMap.builder().put((Object)"message", (Object)IssueAttribute.MESSAGE).put((Object)"effortToFix", (Object)IssueAttribute.EFFORT_TO_FIX).put((Object)"sc", (Object)IssueAttribute.START_COLUMN).put((Object)"startColumn", (Object)IssueAttribute.START_COLUMN).put((Object)"el", (Object)IssueAttribute.END_LINE).put((Object)"endLine", (Object)IssueAttribute.END_LINE).put((Object)"ec", (Object)IssueAttribute.END_COLUMN).put((Object)"endColumn", (Object)IssueAttribute.END_COLUMN).put((Object)"secondary", (Object)IssueAttribute.SECONDARY_LOCATIONS).build();
    private final ArrayListMultimap<Integer, Map<IssueAttribute, String>> expected = ArrayListMultimap.create();
    private boolean expectNoIssues = false;
    private String expectFileIssue;
    private Integer expectFileIssueOnline;

    public void expectNoIssues() {
        this.expectNoIssues = true;
    }

    public void setExpectedFileIssue(String expectFileIssue) {
        this.expectFileIssue = expectFileIssue;
    }

    public void expectFileIssueOnline(Integer expectFileIssueOnline) {
        this.expectFileIssueOnline = expectFileIssueOnline;
    }

    public abstract String getExpectedIssueTrigger();

    protected void collectExpectedIssues(String comment, int line) {
        String expectedStart = this.getExpectedIssueTrigger();
        if (comment.startsWith(expectedStart)) {
            String cleanedComment = StringUtils.remove((String)comment, (String)expectedStart);
            EnumMap<IssueAttribute, String> attr = new EnumMap<IssueAttribute, String>(IssueAttribute.class);
            String expectedMessage = StringUtils.substringBetween((String)cleanedComment, (String)"{{", (String)"}}");
            if (StringUtils.isNotEmpty((String)expectedMessage)) {
                attr.put(IssueAttribute.MESSAGE, expectedMessage);
            }
            int expectedLine = line;
            String attributesSubstr = CheckVerifier.extractAttributes(comment, attr);
            if (StringUtils.startsWith((String)(cleanedComment = StringUtils.stripEnd((String)StringUtils.remove((String)StringUtils.remove((String)cleanedComment, (String)("[[" + attributesSubstr + "]]")), (String)("{{" + expectedMessage + "}}")), (String)" \t")), (String)"@")) {
                char firstChar = cleanedComment.charAt(1);
                int endIndex = cleanedComment.indexOf(32);
                int lineAdjustment = endIndex == -1 ? Integer.parseInt(cleanedComment.substring(2)) : Integer.parseInt(cleanedComment.substring(2, endIndex));
                if (firstChar == '+') {
                    expectedLine += lineAdjustment;
                } else if (firstChar == '-') {
                    expectedLine -= lineAdjustment;
                } else {
                    Fail.fail((String)"Use only '@+N' or '@-N' to shifts messages.");
                }
            }
            CheckVerifier.updateEndLine(expectedLine, attr);
            this.expected.put((Object)expectedLine, attr);
        }
    }

    private static String extractAttributes(String comment, Map<IssueAttribute, String> attr) {
        String attributesSubstr = StringUtils.substringBetween((String)comment, (String)"[[", (String)"]]");
        if (!StringUtils.isEmpty((String)attributesSubstr)) {
            Iterable attributes = Splitter.on((String)";").split((CharSequence)attributesSubstr);
            for (String attribute : attributes) {
                String[] split = StringUtils.split((String)attribute, (char)'=');
                if (split.length == 2 && ATTRIBUTE_MAP.containsKey(split[0])) {
                    attr.put(ATTRIBUTE_MAP.get(split[0]), split[1]);
                    continue;
                }
                Fail.fail((String)("// Noncompliant attributes not valid: " + attributesSubstr));
            }
        }
        return attributesSubstr;
    }

    private static void updateEndLine(int expectedLine, EnumMap<IssueAttribute, String> attr) {
        if (attr.containsKey((Object)IssueAttribute.END_LINE)) {
            String endLineStr = attr.get((Object)IssueAttribute.END_LINE);
            if (endLineStr.charAt(0) == '+') {
                int endLine = Integer.parseInt(endLineStr);
                attr.put(IssueAttribute.END_LINE, Integer.toString(expectedLine + endLine));
            } else {
                Fail.fail((String)"endLine attribute should be relative to the line and must be +N with N integer");
            }
        }
    }

    public ArrayListMultimap<Integer, Map<IssueAttribute, String>> getExpected() {
        return this.expected;
    }

    public void checkIssues(Set<AnalyzerMessage> issues, boolean bypassNoIssue) {
        if (this.expectNoIssues) {
            this.assertNoIssues(issues, bypassNoIssue);
        } else if (StringUtils.isNotEmpty((String)this.expectFileIssue)) {
            this.assertSingleIssue(issues);
        } else {
            this.assertMultipleIssue(issues);
        }
    }

    private void assertMultipleIssue(Set<AnalyzerMessage> issues) throws AssertionError {
        Preconditions.checkState((!issues.isEmpty() ? 1 : 0) != 0, (Object)"At least one issue expected");
        LinkedList unexpectedLines = Lists.newLinkedList();
        for (AnalyzerMessage issue : issues) {
            CheckVerifier.validateIssue(this.expected, unexpectedLines, issue);
        }
        if (!this.expected.isEmpty() || !unexpectedLines.isEmpty()) {
            String expectedMsg;
            Collections.sort(unexpectedLines);
            String string = expectedMsg = !this.expected.isEmpty() ? "Expected " + this.expected : "";
            String unexpectedMsg = !unexpectedLines.isEmpty() ? (expectedMsg.isEmpty() ? "" : ", ") + "Unexpected at " + unexpectedLines : "";
            Fail.fail((String)(expectedMsg + unexpectedMsg));
        }
    }

    private static void validateIssue(Multimap<Integer, Map<IssueAttribute, String>> expected, List<Integer> unexpectedLines, AnalyzerMessage issue) {
        int line = issue.getLine();
        if (expected.containsKey((Object)line)) {
            Map attrs = (Map)Iterables.getLast((Iterable)expected.get((Object)line));
            CheckVerifier.assertEquals(issue.getMessage(), attrs, IssueAttribute.MESSAGE);
            Double cost = issue.getCost();
            if (cost != null) {
                CheckVerifier.assertEquals(Integer.toString(cost.intValue()), attrs, IssueAttribute.EFFORT_TO_FIX);
            }
            CheckVerifier.validateAnalyzerMessage(attrs, issue);
            expected.remove((Object)line, (Object)attrs);
        } else {
            unexpectedLines.add(line);
        }
    }

    private static void validateAnalyzerMessage(Map<IssueAttribute, String> attrs, AnalyzerMessage analyzerMessage) {
        Double effortToFix = analyzerMessage.getCost();
        if (effortToFix != null) {
            CheckVerifier.assertEquals(Integer.toString(effortToFix.intValue()), attrs, IssueAttribute.EFFORT_TO_FIX);
        }
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        CheckVerifier.assertEquals(CheckVerifier.normalizeColumn(textSpan.startCharacter), attrs, IssueAttribute.START_COLUMN);
        CheckVerifier.assertEquals(Integer.toString(textSpan.endLine), attrs, IssueAttribute.END_LINE);
        CheckVerifier.assertEquals(CheckVerifier.normalizeColumn(textSpan.endCharacter), attrs, IssueAttribute.END_COLUMN);
        if (attrs.containsKey((Object)IssueAttribute.SECONDARY_LOCATIONS)) {
            List secondaryLocations = analyzerMessage.secondaryLocations;
            HashMultiset actualLines = HashMultiset.create();
            for (AnalyzerMessage secondaryLocation : secondaryLocations) {
                actualLines.add((Object)Integer.toString(secondaryLocation.getLine()));
            }
            ArrayList expected = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)attrs.get((Object)IssueAttribute.SECONDARY_LOCATIONS)));
            ArrayList<String> unexpected = new ArrayList<String>();
            for (String actualLine : actualLines) {
                if (expected.contains(actualLine)) {
                    expected.remove(actualLine);
                    continue;
                }
                unexpected.add(actualLine);
            }
            if (!expected.isEmpty() || !unexpected.isEmpty()) {
                Fail.fail((String)("Secondary locations: expected: " + expected + " unexpected:" + unexpected));
            }
        }
    }

    private static String normalizeColumn(int startCharacter) {
        return Integer.toString(startCharacter + 1);
    }

    private static void assertEquals(String value, Map<IssueAttribute, String> attributes, IssueAttribute attribute) {
        if (attributes.containsKey((Object)attribute)) {
            ((StringAssert)Assertions.assertThat((String)value).as("attribute mismatch for " + (Object)((Object)attribute) + ": " + attributes)).isEqualTo((Object)attributes.get((Object)attribute));
        }
    }

    private void assertSingleIssue(Set<AnalyzerMessage> issues) {
        Preconditions.checkState((issues.size() == 1 ? 1 : 0) != 0, (Object)("A single issue is expected with line " + this.expectFileIssueOnline));
        AnalyzerMessage issue = (AnalyzerMessage)Iterables.getFirst(issues, null);
        Assertions.assertThat((Integer)issue.getLine()).isEqualTo((Object)this.expectFileIssueOnline);
        Assertions.assertThat((String)issue.getMessage()).isEqualTo((Object)this.expectFileIssue);
    }

    private void assertNoIssues(Set<AnalyzerMessage> issues, boolean bypass) {
        ((CollectionAssert)Assertions.assertThat(issues).overridingErrorMessage("No issues expected but got: " + issues)).isEmpty();
        if (!bypass) {
            ((BooleanAssert)Assertions.assertThat((boolean)this.expected.isEmpty()).overridingErrorMessage("The file should not declare noncompliants when no issues are expected")).isTrue();
        }
    }

    public static enum IssueAttribute {
        MESSAGE,
        START_COLUMN,
        END_COLUMN,
        END_LINE,
        EFFORT_TO_FIX,
        SECONDARY_LOCATIONS;

    }
}

