/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.Fail;
import org.fest.assertions.StringAssert;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.JavaCheckMessage;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceCode;

@Beta
public class JavaCheckVerifier
extends SubscriptionVisitor {
    private static final String DEFAULT_TEST_JARS_DIRECTORY = "target/test-jars";
    private static final String TRIGGER = "// Noncompliant";
    private final ArrayListMultimap<Integer, Map<IssueAttribute, String>> expected = ArrayListMultimap.create();
    private String testJarsDirectory = "target/test-jars";
    private boolean expectNoIssues = false;
    private String expectFileIssue;
    private Integer expectFileIssueOnline;
    private static final Map<String, IssueAttribute> ATTRIBUTE_MAP = ImmutableMap.builder().put((Object)"message", (Object)IssueAttribute.MESSAGE).put((Object)"effortToFix", (Object)IssueAttribute.EFFORT_TO_FIX).put((Object)"sc", (Object)IssueAttribute.START_COLUMN).put((Object)"startColumn", (Object)IssueAttribute.START_COLUMN).put((Object)"el", (Object)IssueAttribute.END_LINE).put((Object)"endLine", (Object)IssueAttribute.END_LINE).put((Object)"ec", (Object)IssueAttribute.END_COLUMN).put((Object)"endColumn", (Object)IssueAttribute.END_COLUMN).put((Object)"secondary", (Object)IssueAttribute.SECONDARY_LOCATIONS).build();

    private JavaCheckVerifier() {
    }

    public static void verify(String filename, JavaFileScanner check) {
        JavaCheckVerifier.scanFile(filename, check, new JavaCheckVerifier());
    }

    public static void verify(String filename, JavaFileScanner check, Collection<File> classpath) {
        JavaCheckVerifier.scanFile(filename, check, new JavaCheckVerifier(), classpath);
    }

    public static void verify(String filename, JavaFileScanner check, String testJarsDirectory) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.testJarsDirectory = testJarsDirectory;
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyNoIssue(String filename, JavaFileScanner check) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.expectNoIssues = true;
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyIssueOnFile(String filename, String message, JavaFileScanner check) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.expectFileIssue = message;
        javaCheckVerifier.expectFileIssueOnline = null;
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    private static void scanFile(String filename, JavaFileScanner check, JavaCheckVerifier javaCheckVerifier) {
        Collection classpath = Lists.newLinkedList();
        File testJars = new File(javaCheckVerifier.testJarsDirectory);
        if (testJars.exists()) {
            classpath = FileUtils.listFiles((File)testJars, (String[])new String[]{"jar", "zip"}, (boolean)true);
        } else if (!DEFAULT_TEST_JARS_DIRECTORY.equals(javaCheckVerifier.testJarsDirectory)) {
            Fail.fail((String)("The directory to be used to extend class path does not exists (" + testJars.getAbsolutePath() + ")."));
        }
        classpath.add(new File("target/test-classes"));
        JavaAstScanner.scanSingleFile((File)new File(filename), (VisitorsBridge)new VisitorsBridge((Iterable)Lists.newArrayList((Object[])new JavaFileScanner[]{check, javaCheckVerifier}), (List)Lists.newArrayList((Iterable)classpath), null));
    }

    private static void scanFile(String filename, JavaFileScanner check, JavaCheckVerifier javaCheckVerifier, Collection<File> classpath) {
        JavaAstScanner.scanSingleFile((File)new File(filename), (VisitorsBridge)new VisitorsBridge((Iterable)Lists.newArrayList((Object[])new JavaFileScanner[]{check, javaCheckVerifier}), (List)Lists.newArrayList(classpath), null));
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRIVIA);
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        this.collectExpectedIssues(syntaxTrivia.comment(), syntaxTrivia.startLine());
    }

    private void collectExpectedIssues(String comment, int line) {
        if (comment.startsWith(TRIGGER)) {
            String cleanedComment = StringUtils.remove((String)comment, (String)TRIGGER);
            EnumMap<IssueAttribute, String> attr = new EnumMap<IssueAttribute, String>(IssueAttribute.class);
            String expectedMessage = StringUtils.substringBetween((String)cleanedComment, (String)"{{", (String)"}}");
            if (StringUtils.isNotEmpty((String)expectedMessage)) {
                attr.put(IssueAttribute.MESSAGE, expectedMessage);
            }
            int expectedLine = line;
            String attributesSubstr = JavaCheckVerifier.extractAttributes(comment, attr);
            if (StringUtils.startsWith((String)(cleanedComment = StringUtils.stripEnd((String)StringUtils.remove((String)StringUtils.remove((String)cleanedComment, (String)("[[" + attributesSubstr + "]]")), (String)("{{" + expectedMessage + "}}")), (String)" \t")), (String)"@")) {
                char firstChar = cleanedComment.charAt(1);
                int endIndex = cleanedComment.indexOf(32);
                int lineAdjustment = endIndex == -1 ? Integer.parseInt(cleanedComment.substring(2)) : Integer.parseInt(cleanedComment.substring(2, endIndex));
                if (firstChar == '+') {
                    expectedLine += lineAdjustment;
                } else if (firstChar == '-') {
                    expectedLine -= lineAdjustment;
                } else {
                    Fail.fail((String)"Use only '@+N' or '@-N' to shifts messages.");
                }
            }
            JavaCheckVerifier.updateEndLine(expectedLine, attr);
            this.expected.put((Object)expectedLine, attr);
        }
    }

    private static void updateEndLine(int expectedLine, EnumMap<IssueAttribute, String> attr) {
        if (attr.containsKey((Object)IssueAttribute.END_LINE)) {
            String endLineStr = attr.get((Object)IssueAttribute.END_LINE);
            if (endLineStr.startsWith("+")) {
                int endLine = Integer.parseInt(endLineStr);
                attr.put(IssueAttribute.END_LINE, Integer.toString(expectedLine + endLine));
            } else {
                Fail.fail((String)"endLine attribute should be relative to the line and must be +N with N integer");
            }
        }
    }

    private static String extractAttributes(String comment, Map<IssueAttribute, String> attr) {
        String attributesSubstr = StringUtils.substringBetween((String)comment, (String)"[[", (String)"]]");
        if (!StringUtils.isEmpty((String)attributesSubstr)) {
            Iterable attributes = Splitter.on((String)";").split((CharSequence)attributesSubstr);
            for (String attribute : attributes) {
                String[] split = StringUtils.split((String)attribute, (char)'=');
                if (split.length == 2 && ATTRIBUTE_MAP.containsKey(split[0])) {
                    attr.put(ATTRIBUTE_MAP.get(split[0]), split[1]);
                    continue;
                }
                Fail.fail((String)("// Noncompliant attributes not valid: " + attributesSubstr));
            }
        }
        return attributesSubstr;
    }

    public void scanFile(JavaFileScannerContext context) {
        this.expected.clear();
        super.scanFile(context);
        VisitorsBridge.DefaultJavaFileScannerContext djfsc = (VisitorsBridge.DefaultJavaFileScannerContext)context;
        this.checkIssues((SourceCode)djfsc.sourceFile);
        this.expected.clear();
    }

    private void checkIssues(SourceCode sourceCode) {
        if (this.expectNoIssues) {
            this.assertNoIssues(sourceCode);
        } else if (StringUtils.isNotEmpty((String)this.expectFileIssue)) {
            this.assertSingleIssue(sourceCode);
        } else {
            this.assertMultipleIssue(sourceCode);
        }
    }

    private void assertMultipleIssue(SourceCode sourceCode) throws AssertionError {
        Preconditions.checkState((boolean)sourceCode.hasCheckMessages(), (Object)"At least one issue expected");
        LinkedList unexpectedLines = Lists.newLinkedList();
        for (CheckMessage checkMessage : sourceCode.getCheckMessages()) {
            this.validateIssue(unexpectedLines, checkMessage);
        }
        if (!this.expected.isEmpty() || !unexpectedLines.isEmpty()) {
            String expectedMsg;
            Collections.sort(unexpectedLines);
            String string = expectedMsg = !this.expected.isEmpty() ? "Expected " + this.expected : "";
            String unexpectedMsg = !unexpectedLines.isEmpty() ? (expectedMsg.isEmpty() ? "" : ", ") + "Unexpected at " + unexpectedLines : "";
            Fail.fail((String)(expectedMsg + unexpectedMsg));
        }
    }

    private void validateIssue(List<Integer> unexpectedLines, CheckMessage checkMessage) {
        int line = checkMessage.getLine();
        if (this.expected.containsKey((Object)line)) {
            AnalyzerMessage analyzerMessage;
            Map attrs = (Map)Iterables.getLast((Iterable)this.expected.get((Object)line));
            JavaCheckVerifier.assertEquals(checkMessage.getText(Locale.US), attrs, IssueAttribute.MESSAGE);
            Double cost = checkMessage.getCost();
            if (cost != null) {
                JavaCheckVerifier.assertEquals(Integer.toString(cost.intValue()), attrs, IssueAttribute.EFFORT_TO_FIX);
            }
            if (checkMessage instanceof JavaCheckMessage && (analyzerMessage = ((JavaCheckMessage)checkMessage).getAnalyzerMessage()) != null) {
                JavaCheckVerifier.validateAnalyzerMessage(attrs, analyzerMessage);
            }
            this.expected.remove((Object)line, (Object)attrs);
        } else {
            unexpectedLines.add(line);
        }
    }

    private static void validateAnalyzerMessage(Map<IssueAttribute, String> attrs, AnalyzerMessage analyzerMessage) {
        Double effortToFix = analyzerMessage.getCost();
        if (effortToFix != null) {
            JavaCheckVerifier.assertEquals(Integer.toString(effortToFix.intValue()), attrs, IssueAttribute.EFFORT_TO_FIX);
        }
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        JavaCheckVerifier.assertEquals(JavaCheckVerifier.normalizeColumn(textSpan.startCharacter), attrs, IssueAttribute.START_COLUMN);
        JavaCheckVerifier.assertEquals(Integer.toString(textSpan.endLine), attrs, IssueAttribute.END_LINE);
        JavaCheckVerifier.assertEquals(JavaCheckVerifier.normalizeColumn(textSpan.endCharacter), attrs, IssueAttribute.END_COLUMN);
        if (attrs.containsKey((Object)IssueAttribute.SECONDARY_LOCATIONS)) {
            List secondaryLocations = analyzerMessage.secondaryLocations;
            HashMultiset actualLines = HashMultiset.create();
            for (AnalyzerMessage secondaryLocation : secondaryLocations) {
                actualLines.add((Object)Integer.toString(secondaryLocation.getLine()));
            }
            ArrayList expected = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)attrs.get((Object)IssueAttribute.SECONDARY_LOCATIONS)));
            ArrayList<String> unexpected = new ArrayList<String>();
            for (String actualLine : actualLines) {
                if (expected.contains(actualLine)) {
                    expected.remove(actualLine);
                    continue;
                }
                unexpected.add(actualLine);
            }
            if (!expected.isEmpty() || !unexpected.isEmpty()) {
                Fail.fail((String)("Secondary locations: expected: " + expected + " unexpected:" + unexpected));
            }
        }
    }

    private static String normalizeColumn(int startCharacter) {
        return Integer.toString(startCharacter + 1);
    }

    private static void assertEquals(String value, Map<IssueAttribute, String> attributes, IssueAttribute attribute) {
        if (attributes.containsKey((Object)attribute)) {
            ((StringAssert)Assertions.assertThat((String)value).as("attribute mismatch for " + (Object)((Object)attribute) + ": " + attributes)).isEqualTo((Object)attributes.get((Object)attribute));
        }
    }

    private void assertSingleIssue(SourceCode sourceCode) {
        Set checkMessages = sourceCode.getCheckMessages();
        Preconditions.checkState((checkMessages.size() == 1 ? 1 : 0) != 0, (Object)("A single issue is expected with line " + this.expectFileIssueOnline));
        CheckMessage checkMessage = (CheckMessage)Iterables.getFirst((Iterable)checkMessages, null);
        Assertions.assertThat((Integer)checkMessage.getLine()).isEqualTo((Object)this.expectFileIssueOnline);
        Assertions.assertThat((String)checkMessage.getText(Locale.US)).isEqualTo((Object)this.expectFileIssue);
    }

    private void assertNoIssues(SourceCode sourceCode) {
        ((CollectionAssert)Assertions.assertThat((Collection)sourceCode.getCheckMessages()).overridingErrorMessage("No issues expected but got: " + sourceCode.getCheckMessages())).isEmpty();
        ((BooleanAssert)Assertions.assertThat((boolean)this.expected.isEmpty()).overridingErrorMessage("The file should not declare noncompliants when no issues are expected")).isTrue();
    }

    static enum IssueAttribute {
        MESSAGE,
        START_COLUMN,
        END_COLUMN,
        END_LINE,
        EFFORT_TO_FIX,
        SECONDARY_LOCATIONS;

    }
}

