/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.Fail;
import org.fest.assertions.StringAssert;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

@Beta
public class JavaCheckVerifier
extends SubscriptionVisitor {
    private static final String DEFAULT_TEST_JARS_DIRECTORY = "target/test-jars";
    private static final String TRIGGER = "// Noncompliant";
    private final ArrayListMultimap<Integer, Map<IssueAttribute, String>> expected = ArrayListMultimap.create();
    private String testJarsDirectory = "target/test-jars";
    private boolean expectNoIssues = false;
    private String expectFileIssue;
    private Integer expectFileIssueOnline;
    private boolean providedJavaVersion = false;
    private Integer javaVersion;
    private static final Map<String, IssueAttribute> ATTRIBUTE_MAP = ImmutableMap.builder().put((Object)"message", (Object)IssueAttribute.MESSAGE).put((Object)"effortToFix", (Object)IssueAttribute.EFFORT_TO_FIX).put((Object)"sc", (Object)IssueAttribute.START_COLUMN).put((Object)"startColumn", (Object)IssueAttribute.START_COLUMN).put((Object)"el", (Object)IssueAttribute.END_LINE).put((Object)"endLine", (Object)IssueAttribute.END_LINE).put((Object)"ec", (Object)IssueAttribute.END_COLUMN).put((Object)"endColumn", (Object)IssueAttribute.END_COLUMN).put((Object)"secondary", (Object)IssueAttribute.SECONDARY_LOCATIONS).build();

    private JavaCheckVerifier() {
    }

    public static void verify(String filename, JavaFileScanner check) {
        JavaCheckVerifier.scanFile(filename, check, new JavaCheckVerifier());
    }

    public static void verify(String filename, JavaFileScanner check, @Nullable Integer javaVersion) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.providedJavaVersion = true;
        javaCheckVerifier.javaVersion = javaVersion;
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verify(String filename, JavaFileScanner check, Collection<File> classpath) {
        JavaCheckVerifier.scanFile(filename, check, new JavaCheckVerifier(), classpath);
    }

    public static void verify(String filename, JavaFileScanner check, String testJarsDirectory) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.testJarsDirectory = testJarsDirectory;
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyNoIssue(String filename, JavaFileScanner check) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.expectNoIssues = true;
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyNoIssue(String filename, JavaFileScanner check, @Nullable Integer javaVersion) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.expectNoIssues = true;
        javaCheckVerifier.providedJavaVersion = true;
        javaCheckVerifier.javaVersion = javaVersion;
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyIssueOnFile(String filename, String message, JavaFileScanner check) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.expectFileIssue = message;
        javaCheckVerifier.expectFileIssueOnline = null;
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    private static void scanFile(String filename, JavaFileScanner check, JavaCheckVerifier javaCheckVerifier) {
        Collection classpath = Lists.newLinkedList();
        File testJars = new File(javaCheckVerifier.testJarsDirectory);
        if (testJars.exists()) {
            classpath = FileUtils.listFiles((File)testJars, (String[])new String[]{"jar", "zip"}, (boolean)true);
        } else if (!DEFAULT_TEST_JARS_DIRECTORY.equals(javaCheckVerifier.testJarsDirectory)) {
            Fail.fail((String)("The directory to be used to extend class path does not exists (" + testJars.getAbsolutePath() + ")."));
        }
        classpath.add(new File("target/test-classes"));
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier, classpath);
    }

    private static void scanFile(String filename, JavaFileScanner check, JavaCheckVerifier javaCheckVerifier, Collection<File> classpath) {
        VisitorsBridge visitorsBridge = new VisitorsBridge((Iterable)Lists.newArrayList((Object[])new JavaFileScanner[]{check, javaCheckVerifier}), (List)Lists.newArrayList(classpath), null);
        JavaConfiguration conf = new JavaConfiguration(Charset.forName("UTF-8"));
        conf.setJavaVersion(javaCheckVerifier.javaVersion);
        JavaAstScanner.scanSingleFileForTests((File)new File(filename), (VisitorsBridge)visitorsBridge, (JavaConfiguration)conf);
        VisitorsBridge.TestJavaFileScannerContext testJavaFileScannerContext = visitorsBridge.lastCreatedTestContext();
        JavaCheckVerifier.checkIssues(testJavaFileScannerContext.getIssues(), javaCheckVerifier);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRIVIA);
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        this.collectExpectedIssues(syntaxTrivia.comment(), syntaxTrivia.startLine());
    }

    private void collectExpectedIssues(String comment, int line) {
        if (comment.startsWith(TRIGGER)) {
            String cleanedComment = StringUtils.remove((String)comment, (String)TRIGGER);
            EnumMap<IssueAttribute, String> attr = new EnumMap<IssueAttribute, String>(IssueAttribute.class);
            String expectedMessage = StringUtils.substringBetween((String)cleanedComment, (String)"{{", (String)"}}");
            if (StringUtils.isNotEmpty((String)expectedMessage)) {
                attr.put(IssueAttribute.MESSAGE, expectedMessage);
            }
            int expectedLine = line;
            String attributesSubstr = JavaCheckVerifier.extractAttributes(comment, attr);
            if (StringUtils.startsWith((String)(cleanedComment = StringUtils.stripEnd((String)StringUtils.remove((String)StringUtils.remove((String)cleanedComment, (String)("[[" + attributesSubstr + "]]")), (String)("{{" + expectedMessage + "}}")), (String)" \t")), (String)"@")) {
                char firstChar = cleanedComment.charAt(1);
                int endIndex = cleanedComment.indexOf(32);
                int lineAdjustment = endIndex == -1 ? Integer.parseInt(cleanedComment.substring(2)) : Integer.parseInt(cleanedComment.substring(2, endIndex));
                if (firstChar == '+') {
                    expectedLine += lineAdjustment;
                } else if (firstChar == '-') {
                    expectedLine -= lineAdjustment;
                } else {
                    Fail.fail((String)"Use only '@+N' or '@-N' to shifts messages.");
                }
            }
            JavaCheckVerifier.updateEndLine(expectedLine, attr);
            this.expected.put((Object)expectedLine, attr);
        }
    }

    private static void updateEndLine(int expectedLine, EnumMap<IssueAttribute, String> attr) {
        if (attr.containsKey((Object)IssueAttribute.END_LINE)) {
            String endLineStr = attr.get((Object)IssueAttribute.END_LINE);
            if (endLineStr.startsWith("+")) {
                int endLine = Integer.parseInt(endLineStr);
                attr.put(IssueAttribute.END_LINE, Integer.toString(expectedLine + endLine));
            } else {
                Fail.fail((String)"endLine attribute should be relative to the line and must be +N with N integer");
            }
        }
    }

    private static String extractAttributes(String comment, Map<IssueAttribute, String> attr) {
        String attributesSubstr = StringUtils.substringBetween((String)comment, (String)"[[", (String)"]]");
        if (!StringUtils.isEmpty((String)attributesSubstr)) {
            Iterable attributes = Splitter.on((String)";").split((CharSequence)attributesSubstr);
            for (String attribute : attributes) {
                String[] split = StringUtils.split((String)attribute, (char)'=');
                if (split.length == 2 && ATTRIBUTE_MAP.containsKey(split[0])) {
                    attr.put(ATTRIBUTE_MAP.get(split[0]), split[1]);
                    continue;
                }
                Fail.fail((String)("// Noncompliant attributes not valid: " + attributesSubstr));
            }
        }
        return attributesSubstr;
    }

    private static void checkIssues(Set<AnalyzerMessage> issues, JavaCheckVerifier javaCheckVerifier) {
        if (javaCheckVerifier.expectNoIssues) {
            JavaCheckVerifier.assertNoIssues(javaCheckVerifier.expected, issues, javaCheckVerifier.providedJavaVersion);
        } else if (StringUtils.isNotEmpty((String)javaCheckVerifier.expectFileIssue)) {
            JavaCheckVerifier.assertSingleIssue(javaCheckVerifier.expectFileIssueOnline, javaCheckVerifier.expectFileIssue, issues);
        } else {
            JavaCheckVerifier.assertMultipleIssue(javaCheckVerifier.expected, issues);
        }
    }

    private static void assertMultipleIssue(Multimap<Integer, Map<IssueAttribute, String>> expected, Set<AnalyzerMessage> issues) throws AssertionError {
        Preconditions.checkState((!issues.isEmpty() ? 1 : 0) != 0, (Object)"At least one issue expected");
        LinkedList unexpectedLines = Lists.newLinkedList();
        for (AnalyzerMessage issue : issues) {
            JavaCheckVerifier.validateIssue(expected, unexpectedLines, issue);
        }
        if (!expected.isEmpty() || !unexpectedLines.isEmpty()) {
            String expectedMsg;
            Collections.sort(unexpectedLines);
            String string = expectedMsg = !expected.isEmpty() ? "Expected " + expected : "";
            String unexpectedMsg = !unexpectedLines.isEmpty() ? (expectedMsg.isEmpty() ? "" : ", ") + "Unexpected at " + unexpectedLines : "";
            Fail.fail((String)(expectedMsg + unexpectedMsg));
        }
    }

    private static void validateIssue(Multimap<Integer, Map<IssueAttribute, String>> expected, List<Integer> unexpectedLines, AnalyzerMessage issue) {
        int line = issue.getLine();
        if (expected.containsKey((Object)line)) {
            Map attrs = (Map)Iterables.getLast((Iterable)expected.get((Object)line));
            JavaCheckVerifier.assertEquals(issue.getMessage(), attrs, IssueAttribute.MESSAGE);
            Double cost = issue.getCost();
            if (cost != null) {
                JavaCheckVerifier.assertEquals(Integer.toString(cost.intValue()), attrs, IssueAttribute.EFFORT_TO_FIX);
            }
            JavaCheckVerifier.validateAnalyzerMessage(attrs, issue);
            expected.remove((Object)line, (Object)attrs);
        } else {
            unexpectedLines.add(line);
        }
    }

    private static void validateAnalyzerMessage(Map<IssueAttribute, String> attrs, AnalyzerMessage analyzerMessage) {
        Double effortToFix = analyzerMessage.getCost();
        if (effortToFix != null) {
            JavaCheckVerifier.assertEquals(Integer.toString(effortToFix.intValue()), attrs, IssueAttribute.EFFORT_TO_FIX);
        }
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        JavaCheckVerifier.assertEquals(JavaCheckVerifier.normalizeColumn(textSpan.startCharacter), attrs, IssueAttribute.START_COLUMN);
        JavaCheckVerifier.assertEquals(Integer.toString(textSpan.endLine), attrs, IssueAttribute.END_LINE);
        JavaCheckVerifier.assertEquals(JavaCheckVerifier.normalizeColumn(textSpan.endCharacter), attrs, IssueAttribute.END_COLUMN);
        if (attrs.containsKey((Object)IssueAttribute.SECONDARY_LOCATIONS)) {
            List secondaryLocations = analyzerMessage.secondaryLocations;
            HashMultiset actualLines = HashMultiset.create();
            for (AnalyzerMessage secondaryLocation : secondaryLocations) {
                actualLines.add((Object)Integer.toString(secondaryLocation.getLine()));
            }
            ArrayList expected = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)attrs.get((Object)IssueAttribute.SECONDARY_LOCATIONS)));
            ArrayList<String> unexpected = new ArrayList<String>();
            for (String actualLine : actualLines) {
                if (expected.contains(actualLine)) {
                    expected.remove(actualLine);
                    continue;
                }
                unexpected.add(actualLine);
            }
            if (!expected.isEmpty() || !unexpected.isEmpty()) {
                Fail.fail((String)("Secondary locations: expected: " + expected + " unexpected:" + unexpected));
            }
        }
    }

    private static String normalizeColumn(int startCharacter) {
        return Integer.toString(startCharacter + 1);
    }

    private static void assertEquals(String value, Map<IssueAttribute, String> attributes, IssueAttribute attribute) {
        if (attributes.containsKey((Object)attribute)) {
            ((StringAssert)Assertions.assertThat((String)value).as("attribute mismatch for " + (Object)((Object)attribute) + ": " + attributes)).isEqualTo((Object)attributes.get((Object)attribute));
        }
    }

    private static void assertSingleIssue(Integer expectFileIssueOnline, String expectFileIssue, Set<AnalyzerMessage> issues) {
        Preconditions.checkState((issues.size() == 1 ? 1 : 0) != 0, (Object)("A single issue is expected with line " + expectFileIssueOnline));
        AnalyzerMessage issue = (AnalyzerMessage)Iterables.getFirst(issues, null);
        Assertions.assertThat((Integer)issue.getLine()).isEqualTo((Object)expectFileIssueOnline);
        Assertions.assertThat((String)issue.getMessage()).isEqualTo((Object)expectFileIssue);
    }

    private static void assertNoIssues(Multimap<Integer, Map<IssueAttribute, String>> expected, Set<AnalyzerMessage> issues, boolean providedJavaVersion) {
        ((CollectionAssert)Assertions.assertThat(issues).overridingErrorMessage("No issues expected but got: " + issues)).isEmpty();
        if (!providedJavaVersion) {
            ((BooleanAssert)Assertions.assertThat((boolean)expected.isEmpty()).overridingErrorMessage("The file should not declare noncompliants when no issues are expected")).isTrue();
        }
    }

    static enum IssueAttribute {
        MESSAGE,
        START_COLUMN,
        END_COLUMN,
        END_LINE,
        EFFORT_TO_FIX,
        SECONDARY_LOCATIONS;

    }
}

