/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fest.assertions.Fail;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.checks.verifier.CheckVerifier;
import org.sonar.maven.MavenCheck;
import org.sonar.maven.MavenFileScanner;
import org.sonar.maven.MavenFileScannerContext;
import org.sonar.maven.MavenParser;
import org.sonar.maven.model.LocatedTree;
import org.sonar.maven.model.maven2.MavenProject;
import org.sonar.plugins.java.api.JavaCheck;

@Beta
public class MavenCheckVerifier
extends CheckVerifier {
    private MavenCheckVerifier() {
    }

    @Override
    public String getExpectedIssueTrigger() {
        return "Noncompliant";
    }

    public static void verify(String filename, MavenFileScanner check) {
        MavenCheckVerifier mavenCheckVerifier = new MavenCheckVerifier();
        MavenCheckVerifier.scanFile(filename, check, mavenCheckVerifier);
    }

    public static void verifyNoIssue(String filename, MavenFileScanner check) {
        MavenCheckVerifier mavenCheckVerifier = new MavenCheckVerifier();
        mavenCheckVerifier.expectNoIssues();
        MavenCheckVerifier.scanFile(filename, check, mavenCheckVerifier);
    }

    public static void verifyIssueOnFile(String filename, String message, MavenFileScanner check) {
        MavenCheckVerifier mavenCheckVerifier = new MavenCheckVerifier();
        mavenCheckVerifier.setExpectedFileIssue(message);
        MavenCheckVerifier.scanFile(filename, check, mavenCheckVerifier);
    }

    private static void scanFile(String filename, MavenFileScanner check, MavenCheckVerifier mavenCheckVerifier) {
        File pom = new File(filename);
        MavenProject project = MavenParser.parseXML((File)pom);
        if (project != null) {
            MavenCheckVerifier.retrieveExpectedIssuesFromFile(pom, mavenCheckVerifier);
            FakeMavenFileScannerContext context = new FakeMavenFileScannerContext(pom, project);
            check.scanFile((MavenFileScannerContext)context);
            mavenCheckVerifier.checkIssues(context.messages, false);
        } else {
            Fail.fail((String)"The test file can not be parsed");
        }
    }

    private static void retrieveExpectedIssuesFromFile(File pom, MavenCheckVerifier mavenCheckVerifier) {
        try (FileInputStream is = new FileInputStream(pom);){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(is);
            while (reader.hasNext()) {
                int line = reader.getLocation().getLineNumber();
                reader.next();
                if (reader.getEventType() != 5) continue;
                String text = reader.getText().trim();
                mavenCheckVerifier.collectExpectedIssues(text, line);
            }
        }
        catch (IOException | XMLStreamException e) {
            Fail.fail((String)"The test file can not be parsed to retrieve comments", (Throwable)e);
        }
    }

    private static class FakeMavenFileScannerContext
    implements MavenFileScannerContext {
        private final File file;
        private final MavenProject project;
        private final HashSet<AnalyzerMessage> messages = new HashSet();

        public FakeMavenFileScannerContext(File file, MavenProject project) {
            this.file = file;
            this.project = project;
        }

        public MavenProject getMavenProject() {
            return this.project;
        }

        public void reportIssueOnFile(MavenCheck check, String message) {
            this.messages.add(new AnalyzerMessage((JavaCheck)check, this.file, -1, message, 0));
        }

        public void reportIssue(MavenCheck check, LocatedTree tree, String message) {
            this.messages.add(new AnalyzerMessage((JavaCheck)check, this.file, tree.startLocation().line(), message, 0));
        }

        public void reportIssue(MavenCheck check, int line, String message) {
            this.messages.add(new AnalyzerMessage((JavaCheck)check, this.file, line, message, 0));
        }

        public void reportIssue(MavenCheck check, int line, String message, List<MavenFileScannerContext.Location> secondary) {
            AnalyzerMessage analyzerMessage = new AnalyzerMessage((JavaCheck)check, this.file, line, message, 0);
            for (MavenFileScannerContext.Location location : secondary) {
                AnalyzerMessage secondaryLocation = new AnalyzerMessage((JavaCheck)check, this.file, location.tree.startLocation().line(), location.msg, 0);
                analyzerMessage.secondaryLocations.add(secondaryLocation);
            }
            this.messages.add(analyzerMessage);
        }
    }
}

