/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2698", name="JUnit assertions should include messages", priority=Priority.MAJOR, tags={"junit"})
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="5min")
public class AssertionsWithoutMessageCheck
extends AbstractMethodDetection {
    private static final String GENERIC_ASSERT = "org.fest.assertions.GenericAssert";
    private static final MethodMatcher FEST_AS_METHOD = MethodMatcher.create().typeDefinition("org.fest.assertions.GenericAssert").name("as").addParameter("java.lang.String");
    private static final Set<String> ASSERT_METHODS_WITH_ONE_PARAM = ImmutableSet.of((Object)"assertNull", (Object)"assertNotNull");
    private static final Set<String> ASSERT_METHODS_WITH_TWO_PARAMS = ImmutableSet.of((Object)"assertEquals", (Object)"assertSame", (Object)"assertNotSame", (Object)"assertThat");

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Lists.newArrayList((Object[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("org.junit.Assert").name(NameCriteria.startsWith((String)"assert")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.junit.Assert").name("fail").withNoParameterConstraint(), MethodMatcher.create().typeDefinition("junit.framework.Assert").name(NameCriteria.startsWith((String)"assert")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("junit.framework.Assert").name(NameCriteria.startsWith((String)"fail")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.fest.assertions.Fail").name(NameCriteria.startsWith((String)"fail")).withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)GENERIC_ASSERT)).name(NameCriteria.any()).withNoParameterConstraint()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Symbol symbol = mit.symbol();
        if (symbol.owner().type().isSubtypeOf(GENERIC_ASSERT) && !FEST_AS_METHOD.matches(mit)) {
            if (AssertionsWithoutMessageCheck.isConstructor(symbol)) {
                return;
            }
            FestVisitor visitor = new FestVisitor();
            mit.methodSelect().accept((TreeVisitor)visitor);
            if (!visitor.useDescription) {
                this.reportIssue((Tree)mit, "Add a message to this assertion.");
            }
        } else if (mit.arguments().isEmpty() || !AssertionsWithoutMessageCheck.isString((ExpressionTree)mit.arguments().get(0)) || AssertionsWithoutMessageCheck.isAssertingOnStringWithNoMessage(mit)) {
            this.reportIssue((Tree)mit, "Add a message to this assertion.");
        }
    }

    private static boolean isConstructor(Symbol symbol) {
        return "<init>".equals(symbol.name());
    }

    private static boolean isAssertingOnStringWithNoMessage(MethodInvocationTree mit) {
        return AssertionsWithoutMessageCheck.isAssertWithTwoParams(mit) || AssertionsWithoutMessageCheck.isAssertWithOneParam(mit);
    }

    private static boolean isAssertWithOneParam(MethodInvocationTree mit) {
        return ASSERT_METHODS_WITH_ONE_PARAM.contains(mit.symbol().name()) && mit.arguments().size() == 1;
    }

    private static boolean isAssertWithTwoParams(MethodInvocationTree mit) {
        return ASSERT_METHODS_WITH_TWO_PARAMS.contains(mit.symbol().name()) && mit.arguments().size() == 2;
    }

    private static boolean isString(ExpressionTree expressionTree) {
        return expressionTree.symbolType().is("java.lang.String");
    }

    private static class FestVisitor
    extends BaseTreeVisitor {
        boolean useDescription = false;

        private FestVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            this.useDescription |= FEST_AS_METHOD.matches(tree);
            super.visitMethodInvocation(tree);
        }
    }
}

