/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.SyntaxNodePredicates;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2094", name="Classes should not be empty", priority=Priority.MAJOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class EmptyClassCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        IdentifierTree simpleName = classTree.simpleName();
        if (simpleName != null && EmptyClassCheck.isNotExtending(classTree) && EmptyClassCheck.isEmpty(classTree)) {
            this.reportIssue((Tree)simpleName, "Remove this empty class, write its code or make it an \"interface\".");
        }
    }

    private static boolean isNotExtending(ClassTree tree) {
        return tree.superClass() == null && tree.superInterfaces().isEmpty();
    }

    private static boolean isEmpty(ClassTree tree) {
        return tree.modifiers().annotations().isEmpty() && Iterables.all((Iterable)tree.members(), SyntaxNodePredicates.kind(Tree.Kind.EMPTY_STATEMENT));
    }
}

