/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1641", name="Sets with elements that are enum values should be replaced with EnumSet", priority=Priority.MAJOR, tags={"performance"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class EnumSetCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher GUAVA_IMMUTABLE_ENUM_SET = MethodMatcher.create().typeDefinition("com.google.common.collect.Sets").name("immutableEnumSet").withNoParameterConstraint();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        VariableTree variableTree = (VariableTree)tree;
        ExpressionTree initializer = variableTree.initializer();
        if (initializer != null) {
            this.checkIssue(initializer.symbolType(), (Tree)initializer, variableTree.type());
        }
    }

    private void checkIssue(Type type, Tree reportTree, TypeTree typeTree) {
        if (type.isSubtypeOf("java.util.Set") && !EnumSetCheck.callToImmutableEnumSet(reportTree) && !type.isSubtypeOf("java.util.EnumSet") && type instanceof JavaType.ParametrizedTypeJavaType) {
            JavaType typeParameter;
            JavaType.ParametrizedTypeJavaType parametrizedType = (JavaType.ParametrizedTypeJavaType)type;
            List typeParameters = parametrizedType.typeParameters();
            Type variableType = typeTree.symbolType();
            if (typeParameters.isEmpty() && variableType instanceof JavaType.ParametrizedTypeJavaType) {
                parametrizedType = (JavaType.ParametrizedTypeJavaType)variableType;
                typeParameters = parametrizedType.typeParameters();
            }
            if (!typeParameters.isEmpty() && (typeParameter = parametrizedType.substitution((JavaType.TypeVariableJavaType)typeParameters.get(0))) != null && typeParameter.symbol().isEnum()) {
                this.reportIssue(reportTree, "Convert this Set to an EnumSet.");
            }
        }
    }

    private static boolean callToImmutableEnumSet(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && GUAVA_IMMUTABLE_ENUM_SET.matches((MethodInvocationTree)tree);
    }
}

